# <cfhttp>

Lets you execute HTTP POST and GET operations on files.

Using cfhttp, you can execute standard GET operations and create a query object from a text file.

POST operations lets you upload MIME file types to a server, or post cookie, formfield, URL, file, or CGI variables directly to a specified server.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfhttp
    url=string
    encodeUrl=boolean
    compression=string
    result=string
    addToken=boolean
    port=number
    method=string
    username=string
    password=string
    preAuth=boolean
    multipart=boolean
    multiPartType=string
    getAsBinary=string
    name=string
    columns=string
    path=string
    file=string
    delimiter=string
    textQualifier=string
    resolveURL=boolean
    proxyServer=string
    proxyPort=number
    proxyUser=string
    proxyPassword=string
    userAgent=string
    throwOnError=boolean
    redirect=string
    timeout=any
    connectionTimeout=any
    socketTimeout=any
    charset=string
    firstRowAsHeaders=boolean
    authType=string
    workstation=string
    domain=string
    clientCert=string
    clientCertPassword=string
    pooling=boolean
    cachedWithin=object
    autoCert=boolean
><!--- body ---></cfhttp>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| url | string | Yes | Full URL of the host name or IP address of the server on which the file resides. The URL must be an absolute URL, including the protocol (http or https) and hostname. It may optionally contain a port number. Port numbers specified in the url attribute override the port attribute. |  |
| encodeUrl | boolean | No | if set to true (default value) URL encodes the value of the attribute "URL" if necessary (no double encoding is happening). This setting has no influence on the values from httpparam type="url", for this use the attribute "encoded" from httpparam **Try disabling this (i.e. false) if you are getting strange errors (404s)with API requests** *Alias: encoded, encode* |  |
| compression | string | No | Informs the target webserver to disable compression for the response. Possible values are: - true (default): compression enabled - false: compression disabled - none (deprecated): use "false" instead |  |
| result | string | No | return variable name, default "cfhttp" |  |
| addToken | boolean | No | if yes add urltoken as cookie |  |
| port | number | No | The port number on the server from which the object is requested. Default is 80. When used with resolveURL, the URLs of retrieved documents that specify a port number are automatically resolved to preserve links in the retrieved document. If a port number is specified in the url attribute, the port value overrides the value of the port attribute. |  |
| method | string | No | Supported methods - **GET**: Download content or create queries from text files - **POST**: Send data to server (requires [<cfhttpparam>](httpparam.md)) - **HEAD**: Retrieve headers only, no body content - **PUT**: Upload/replace resource on server - **DELETE**: Remove resource from server - **OPTIONS**: Get allowed methods for resource - **TRACE**: Diagnostic method for request/response chain - **PATCH**: Partially update existing resource Default is GET. |  |
| username | string | No | When required by a server, a valid `username`. |  |
| password | string | No | When required by a server, a valid password. |  |
| preAuth | boolean | No | If set to true (default), Lucee sends the basic authentication (username password) always (Preemptive Basic Authentication) If set to false the authentication is only send when the server ask for it (status code 401). |  |
| multipart | boolean | No | Tells Lucee to send all data specified by cfhttpparam type="formField" tags as multipart form data, with a `Content-Type` of `multipart/form-data`. |  |
| getAsBinary | string | No | Controls how response content is handled: - **false** (default): Auto-detect content type - convert to CFML object if not recognized as text - **auto**: Convert unrecognized content to binary data - **true**: Always return content as binary data, even for text responses Affects the `filecontent` key in the result struct. |  |
| name | string | No | The name to assign to a query if the a query is constructed from a file. |  |
| columns | string | No | Specifies the column names for a query when creating a query as a result of a cfhttp GET. |  |
| path | string | No | The path to the directory in which a file is to be stored. If a path is not specified in a POST or GET operation, a variable is created (cfhttp.fileContent) that you can use to display the results of the POST operation in a cfoutput. |  |
| file | string | No | The filename to be used for the file that is accessed. For GET operations, defaults to the name specified in url. Enter path information in the path attribute. |  |
| delimiter | string | No | Used only when creating a query from an http request that returns data in a CSV format. This value specifies the Field delimiter for the CSV data. Only the first character is used. Default is a comma. |  |
| textQualifier | string | No | Required for creating a query. Indicates the start and finish of a column. Should be appropriately escaped when embedded in a column. For example, if the qualifier is a double quotation mark, it should be escaped as """". If there is no text qualifier in the file, specify it as " ". Default is the double quotation mark ("). |  |
| resolveURL | boolean | No | Yes or No. Default is No. For GET and POST operations, if Yes, page reference returned into the fileContent internal variable has its internal URLs fully resolved, including port number, so that links remain intact. |  |
| proxyServer | string | No | Host name or IP address of a proxy server. |  |
| proxyPort | number | No | The port number on the proxy server from which the object is requested. Default is 80. When used with resolveURL, the URLs of retrieved documents that specify a port number are automatically resolved to preserve links in the retrieved document. |  |
| proxyUser | string | No | When required by a proxy server, a valid username. |  |
| proxyPassword | string | No | When required by a proxy server, a valid password. |  |
| userAgent | string | No | Use a custom `User-Agent` request header. |  |
| throwOnError | boolean | No | Whether to throw an exception on HTTP errors that can be caught with `cftry`/`cfcatch`. When **true**: Throws exceptions for connection failures, lookup errors, or non-2xx status codes. When **false** (default): Populates the result struct with error information instead. The result struct always contains an `ERROR` key indicating if an error occurred, regardless of this setting. |  |
| redirect | string | No | Whether to automatically follow HTTP redirects (3xx status codes). When **true** (default): Automatically follows up to 15 redirects. When **false**: Stops at the first redirect response. Use `cfhttp.responseHeader.LOCATION` to see the redirect target. If redirect limit is exceeded, behaves as if set to false. If set to "Lax", filecontent for redirects for POST and DELETE requests will be returned, since **7.0.0.208** |  |
| timeout | any | No | **General timeout value** in seconds or as a TimeSpan object that serves as a fallback for connection and socket timeouts. When `connectionTimeout` or `socketTimeout` are not specified, this value is used for those timeouts. If no timeout is set, Lucee uses the **remaining request timeout** from the current page context. The request will always timeout at or before the page timeout, using whichever is smaller: the specified timeout or remaining request time. |  |
| connectionTimeout | any | No | **Connection establishment timeout** in seconds or as a TimeSpan object. Controls how long to wait while establishing the initial TCP connection to the server. This timeout triggers during the TCP handshake phase, before any HTTP data is sent. Useful when the target server is unreachable, experiencing network issues, or is overwhelmed and not accepting new connections. If not specified, falls back to the `timeout` attribute value. |  |
| socketTimeout | any | No | **Socket read timeout** in seconds or as a TimeSpan object. Controls how long to wait for data between consecutive data packets after the connection is established. This timeout triggers while waiting for the server's response or if the server stops sending data mid-response. Different from connection timeout as it applies to data transfer, not connection establishment. If not specified, falls back to the `timeout` attribute value. |  |
| charset | string | No | Sets the charset for the call. |  |
| firstRowAsHeaders | boolean | No | sets if first row of csv is file |  |
| authType | string | No | Authentication type for a request with username and password, valid values are "BASIC" (default) and "NTLM" |  |
| workstation | string | No | The workstation the authentication request is originating from. Essentially, the computer name for this machine. This attribute is only used when authentication type is "NTLM" |  |
| domain | string | No | The domain to authenticate within. This attribute is only used when authentication type is "NTLM" |  |
| clientCert | string | No | The full path to a PKCS12 format file that contains the client certificate for the request. |  |
| clientCertPassword | string | No | Password used to decrypt the client certificate. |  |
| pooling | boolean | No | Flag allowing to disable connection reuse on one off requests. |  |
| cachedWithin | object | No | Supported values are: - String "request" (If original content was created within the current request, cached content data is used.) - a timespan (created with function CreateTimeSpan) To use cached data, the tag must be called with the exact same arguments. |  |
| autoCert | boolean | No | When set to true, this attribute enables the automatic installation of SSL certificates for HTTPS connections, ensuring the request can proceed without SSL certificate errors. This is particularly useful for environments where certificates may not be pre-installed or are dynamically updated. |  |


# Usage Notes

For multipart with quoted boundary response, `filecontent` will be an array, see [LDEV-3545](https://luceeserver.atlassian.net/browse/LDEV-3545)

# Examples

### Tags

```cfml
<cfhttp url="https://www.google.com" method="get" result="myresult">
<cfdump var="#myresult#">

<cfhttp url="https://www.google.com" method="get" result="myresult">
    <cfhttpparam type="url" name="q" value="Lucee">
</cfhttp>
<cfdump var="#myresult#">
```

### Script

```cfml
http url="https://www.google.com" method="get" result="myresult";
dump(myresult);

//You can also pass parameters in script format
http url="https://www.google.com/search" method="get" result="myresult"{
    httpparam type="url" name="q" value="Lucee";
}
dump(myresult);
```





## Related System Properties / Environment Variables

- [LUCEE_DISABLE_SYSTEMPROXIES](../../recipes/environment-variables-system-properties.md#lucee_disable_systemproxies) - Boolean value to disable using system proxies for HTTP connections
  ***Type:** boolean, **Default:** false*
- [LUCEE_URL_ENCODEALLOWPLUS](../../recipes/environment-variables-system-properties.md#lucee_url_encodeallowplus) - Enabled by default in Lucee 7, previously Lucee would attempt to re-encode a url param which contained a space. If the url param was already encoded, it would trigger re-encoding the param again, breaking it. This was avoidable previously by using cfhttp encodeurl=`false`, set to `false` to enable previous behaviour
  ***Type:** boolean, **Default:** true, **Introduced:** 6.2.0.171*
- [LUCEE_USE_LUCEE_SSL_TRUSTSTORE](../../recipes/environment-variables-system-properties.md#lucee_use_lucee_ssl_truststore) - Specifies the file location of the trust store that contains trusted Certificate Authorities (CAs) for SSL/TLS connections in Java applications. Lucee 6 uses the JVM trust store by default
  ***Type:** string*



# Categories

[Cache](../../categories/cache.md), [Core CFML Language](../../categories/core.md), [Internet Protocols](../../categories/protocols.md)

# See Also

[Checksum](../../recipes/checksum.md), [internalRequest()](../functions/internalrequest.md), [SSLCertificateInstall()](../functions/sslcertificateinstall.md), [Logging CFHTTP Calls](../../recipes/http-logging.md), [Logging HTTP Calls](../../recipes/logging-http-calls.md), [<cfftp>](ftp.md), [<cfhttpparam>](httpparam.md)