# <cfhtmlhead>

Writes the text specified in the text attribute to the 'head' section of a generated HTML page.

The cfhtmlhead tag can be useful for embedding JavaScript code, or placing other HTML tags such, as META, LINK, TITLE, or BASE in an HTML page header.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfhtmlhead
    text=string
    force=boolean
    variable=string
    id=string
    action=append|read|reset|write
><!--- body ---></cfhtmlhead>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| text | string | No | The text to add to the 'head' area of an HTML page. Everything inside the quotation marks is placed in the 'head' section |  |
| force | boolean | No | if set to true, it works even within a silent block |  |
| variable | string | No | Name of variable to contain the text for htmlhead. |  |
| id | string | No | ID of the snippet that is added, used to ensure that the same snippet will not be added more than once. |  |
| action | string | No | possible actions are: - append (default): append text to the HTML head - read: return the text already set to HTML head - reset: reset/remove text already set to HTML head - write: write text to HTML head, overwrite already existing text in HTML head - flush: writes the buffer in the HTML head to the response stream | append |

# Examples

### Simple Example

```cfml
<cfhtmlhead text="_Read_Action"><cfhtmlhead action="read" variable="res"><br><cfoutput>#res#</cfoutput>

<cfhtmlhead action="write">Started_Write_action</cfhtmlhead><cfhtmlhead action="write">Ended_Write_action</cfhtmlhead>

```








# See Also

[WriteOutput()](../functions/writeoutput.md), [<cfcontent>](content.md), [<cfheader>](header.md), [<cfhtmlbody>](htmlbody.md)