# <cfhtmlbody>

Writes the text specified in the text attribute to the 'body' section of a generated HTML page.
The cfhtmlbody tag can be useful for embedding JavaScript code, or placing other HTML tags that should go at the bottom
of the page just before the closing body tag.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfhtmlbody
    text=string
    variable=string
    id=string
    force=boolean
    action=append|read|reset|write
><!--- body ---></cfhtmlbody>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| text | string | No | The text to add to the 'head' area of an HTML page. Everything inside the quotation marks is placed in the 'head' section |  |
| variable | string | No | Name of variable to contain the text for htmlbody. |  |
| id | string | No | ID of the snippet that is added, used to ensure that the same snippet will not be added more than once. |  |
| force | boolean | No | if set to true, it works even within a silent block |  |
| action | string | No | possible actions are: - append (default): append text to the HTML head - read: return the text already set to HTML head - reset: reset/remove text already set to HTML head - write: write text to HTML head, overwrite already existing text in HTML head - flush: writes the buffer in the HTML head to the response stream | append |

# Examples

### Simple Example

```cfml
  <cfhtmlhead text="Its from HTMLHEAD tag"><br>
  <cfhtmlbody text="It is from HTMLBODY"></cfhtmlbody>
  <cfhtmlbody action="read" variable="res"></cfhtmlbody>
  <cfoutput><b>#res#</b></cfoutput>
```








# See Also

[WriteOutput()](../functions/writeoutput.md), [<cfheader>](header.md), [<cfhtmlhead>](htmlhead.md)