# <cfheader>

Generates custom HTTP response headers to return to the client.

If [<cfflush>](flush.md) has been used, this will throw an error.

You can detect if a page has already been flushed using

```
getPageContext().getHttpServletResponse().isCommitted();
```

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfheader
    name=string
    value=string
    statusCode=number
    charset=string
    statusText=string
><!--- body ---></cfheader>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | No | A name for the header. |  |
| value | string | No | A value for the HTTP header. This attribute is used in conjunction with the name attribute. |  |
| statusCode | number | No | A number that sets the HTTP status code. |  |
| charset | string | No | The character encoding in which to encode the header value. For more information on character encodings, see: <https://www.w3.org/International/questions/qa-html-encoding-declarations>. |  |
| statusText | string | No | Text that explains the status code. This attribute is used in conjunction with the statusCode attribute. |  |

# Examples

```cfml
<cfheader name="Content-Type" value="application/json">
```








# Categories

[Core CFML Language](../../categories/core.md)

# See Also

[GetHTTPRequestData()](../functions/gethttprequestdata.md), [GetHttpTimeString()](../functions/gethttptimestring.md), [<cfcontent>](content.md), [<cfhtmlbody>](htmlbody.md), [<cfhtmlhead>](htmlhead.md)