# <cffunction>

Defines a function call

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cffunction
    name=string
    returnType=string
    bufferOutput=boolean
    roles=string
    access=string
    output=boolean
    displayName=string
    hint=string
    abstract=boolean
    description=string
    returnFormat=string
    secureJson=boolean
    verifyClient=boolean
    localMode=string
    cachedWithin=object
    modifier=string
    consumes=string
    produces=string
    httpMethod=GET|PUT|POST|DELETE
    restPath=string
><!--- body ---></cffunction>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | Yes | A string; a component method that is used within the cfcomponent tag. |  |
| returnType | string | No | String; a type name; data type of the function return value |  |
| bufferOutput | boolean | No | This attribute is only used when output of the function is set to false. If this attribute is set to true (default) the output written to the body of the function is buffered and in case of an exception also outputted. If set to false the content to body is ignored and not disabled when a failure in the body of the tag occur. |  |
| roles | string | No | This attribute is used only for a component. If this attribute is omitted, all roles can invoke the method. |  |
| access | string | No | This attribute is used only within a component. The client security context from which the method can be invoked - remote - public - package - private |  |
| output | boolean | No | This attribute is used only for a component. - yes: the function is processed as if it were within a [<cfoutput>](output.md) tag - no: the function is processed as if it were within a [<cfsilent>](silent.md) tag |  |
| displayName | string | No | Display Name of the Function |  |
| hint | string | No | Hint of the Function |  |
| abstract | boolean | No | is the function abstract or not, abstract functions are only allowed inside interface or component tags |  |
| description | string | No | Supplies a short text description of the function. |  |
| returnFormat | string | No | The format in which to return values to a remote caller. Supported values are - [wddx] - json - plain (text) - serialize (cfml, cfm) - xml - java |  |
| secureJson | boolean | No | A Boolean value that specifies whether to add a security prefix in front of any value that the function returns in JSON-format in response to a remote call. |  |
| verifyClient | boolean | No | A Boolean value that specifies whether to require remote function calls to include an encrypted security token. For use with AJAX applications only. |  |
| localMode | string | No | Defines how the local scope of this function is invoked when a variable with no scope definition is used. Accepted values include: - classic (default): The local scope is only invoked when the key already exists in it (also aliased as `false`). - modern: The local scope is always invoked (also aliased as `true`). |  |
| cachedWithin | object | No | possible values are: - String "request": If original content was created within the current request, cached content data is used. - a timespan (created with [CreateTimeSpan()](../functions/createtimespan.md)): If original content date falls within the time span, cached content data is used. To use cached data, the function must be called with the exact same arguments (part of the cache key is a hash of the arguments) |  |
| modifier | string | No | Use modifier to denote a function as abstract, static or final. - abstract: implementation must be defined in extended component. - final: implementation cannot be extended. - static: does not access instance variables in the component. |  |
| consumes | string | No | A comma-separated list of acceptable MIME types that the function can accept or consume. If no value is specified, all MIME types are consumed by default. Use this attribute to control the types of content the function can handle. This attribute overrides the `consumes` attribute at the component level. |  |
| produces | string | No | A comma-separated list of MIME types that the function can produce. The function will respond with the most acceptable media type as declared by the client. This attribute overrides the `produces` attribute at the component level. |  |
| httpMethod | string | No | Specifies which HTTP method(s) to support when the function is invoked as a RESTful service. Accepted values include: - `GET`: Requests information from the server. - `POST`: Sends information to the server for processing. - `PUT`: Requests the server to store the message body at the specified URL. - `DELETE`: Requests the server to delete the specified URL. - `HEAD`: Similar to GET but without a response body. - `OPTIONS`: Requests information about the communication options available for the server or the specified URL. If not specified, the `GET` method is used by default. Since Lucee 6.1.0.155, Lucee supports multiple http methods per function, i.e `GET,HEAD` |  |
| restPath | string | No | Defines a sub-resource path for the function when used as part of a RESTful web service. The path is case-sensitive and should avoid special characters. Regular expressions can be included in the path. |  |

# Examples

### Simple Example with tag format

```cfml
 	<cffunction access="private" name="add">
		<cfargument name="arg1" type="Numeric" required />
		<cfargument name="arg2" type="Numeric" required />
	 	<cfreturn arg1 + arg2 />
	</cffunction>
	<cfdump var="Define function Using tag.It returns :#add(4,2)#" />
```

### Simple Example with script format

```cfml
		writeDump("Define function using cfscript. It returns: "&add(2,3));
		public function add(required numeric arg1,required numeric arg2){
			return arg1+arg2;
		}
```





## Related System Properties / Environment Variables

- [LUCEE_SUPPRESS_WS_BEFORE_ARG](../../recipes/environment-variables-system-properties.md#lucee_suppress_ws_before_arg) - A boolean value. If enabled, Lucee suppresses whitespace defined between the cffunction starting tag and the last cfargument tag. This setting is ignored when there is different output between these tags as whitespace
  ***Type:** boolean, **Default:** true*
- [LUCEE_UDF_TYPE_CHECKING](../../recipes/environment-variables-system-properties.md#lucee_udf_type_checking) - Alias for lucee.type.checking, enables or disables type checking for user-defined functions
  ***Type:** boolean*



# Categories

[Components (CFCs)](../../categories/component.md), [Core CFML Language](../../categories/core.md), [Static](../../categories/static.md)

# See Also

[IsClosure()](../functions/isclosure.md), [Function Listeners](../../recipes/function-listeners.md), [RestInitApplication()](../functions/restinitapplication.md), [ValueRef()](../functions/valueref.md), [Java in Functions and Closures, function() type='java'](../../recipes/java-in-functions-and-closures.md), [Overwriting and adding Built-in Functions and Tags](../../recipes/overwrite-build-in-functions-tags.md), [REST Services with Lucee](../../recipes/rest-services.md), [<cfargument>](argument.md), [<cfcomponent>](component.md), [<cfreturn>](return.md)