# <cfftp>

Lets users implement File Transfer Protocol (FTP) operations.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfftp
    action=copy|exists|existsFile|existsDir|open|close|changeDir|createDir|getCurrentDir|getCurrentUrl|listDir|removeDir|getFile|putFile|quote|rename|remove
    username=string
    password=string
    server=string
    timeout=number
    port=number
    connection=string
    proxyServer=string
    proxyPort=number
    proxyUser=string
    proxyPassword=string
    retryCount=number
    stopOnError=boolean
    passive=boolean
    name=string
    directory=string
    ASCIIExtensionList=string
    transferMode=string
    remoteFile=string
    localFile=string
    failIfExists=boolean
    existing=string
    new=string
    item=string
    result=string
    fingerprint=string
    secure=string
    recurse=boolean
    key=string
    passphrase=string
    actionParam=string
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| action | string | Yes | the FTP action to be executed - open - close - listDir - createDir - removeDir - changeDir - getCurrentDir - getCurrentURL - existsFile - existsDir - exists - getFile - putFile - rename - remove |  |
| username | string | No | The Username for the connection |  |
| password | string | No | The Password for the connection |  |
| server | string | No | The Server to connect |  |
| timeout | number | No | timeout for the connection |  |
| port | number | No | server port of the connection |  |
| connection | string | No | the name for the connection, used to cache the connection |  |
| proxyServer | string | No | Host name or IP address of a proxy server. |  |
| proxyPort | number | No | The port number on the proxy server from which the object is requested. Default is 80. When used with resolveURL, the URLs of retrieved documents that specify a port number are automatically resolved to preserve links in the retrieved document. |  |
| proxyUser | string | No | When required by a proxy server, a valid username. |  |
| proxyPassword | string | No | When required by a proxy server, a valid password. |  |
| retryCount | number | No | retry count |  |
| stopOnError | boolean | No | define if execution halt on error or not |  |
| passive | boolean | No | enable passive mode |  |
| name | string | No | name of the query for list directory *Alias: variable* |  |
| directory | string | No | remote directory to list |  |
| ASCIIExtensionList | string | No | Delimited list of file extensions that force ASCII transfer mode, if transferMode = "auto". |  |
| transferMode | string | No | - ASCII - binary - auto (default) |  |
| remoteFile | string | No | File on the Server |  |
| localFile | string | No | File on the current machine |  |
| failIfExists | boolean | No | throw an error if local file already exist or overwrite it |  |
| existing | string | No | source or existing file or directory to rename |  |
| new | string | No | new name for file or directory |  |
| item | string | No | item on the server |  |
| result | string | No | Name of the result value (default:cfftp) |  |
| fingerprint | string | No | the ssh fingerprint |  |
| secure | string | No | Secure connection (sftp\|shh) or not. |  |
| recurse | boolean | No | delete content of the directory *Alias: recursive* |  |
| key | string | No | the ssh private key |  |
| passphrase | string | No | the passphrase that protects ssh private key |  |
| actionParam | string | No | used with action="quote" to execute custom ftp commands |  |


# Usage Notes

Lucee 7.0.0.233 adds support for low level debugging

- `LUCEE_FTP_DEBUG=true` enables debug logging to the console for FTP
- `LUCEE_JSCH_DEBUG=true` enables debug logging to the console for SFTP

[LDEV-4318](https://luceeserver.atlassian.net/browse/LDEV-4318)

# Examples

### FTP action open

```cfml
<cfftp action="open"  username="#FTPusername#"  password="#FTPpassword#"  server="#FTPserver#" port="#FTPPort#"  connection="#connection_name#"/>

```

### FTP action close

```cfml
<cfftp action="close" connection="#connection_name#"/>

```

### FTP action listDir

```cfml
<cfftp action="listDir" connection="#connection_name#" name="test" directory="/"/>

```

### FTP action createDir

```cfml
<cfftp action="createDir" connection="#connection_name#"  directory="directoryName"/>

```

### FTP action removeDir

```cfml
<cfftp action="removeDir" username="#FTPusername#" password="#FTPpassword#" server="#FTPserver#" port="#FTPPort#"  directory="directoryName"/>

```

### FTP action existsFile

```cfml
    <cfftp action="existsFile" username="#FTPusername#" password="#FTPpassword#" server="#FTPserver#" port="#FTPPort#"  remotefile="FileName"/>

```

### FTP action putFile

```cfml
    <cfftp action="putFile" username="#FTPusername#" password="#FTPpassword#" server="#FTPserver#" port="#FTPPort#"  remotefile="FileName" localFile="FileName"/>

```

### FTP action existsDir

```cfml
    <cfftp action="existsDir" username="#FTPusername#" password="#FTPpassword#" server="#FTPserver#" port="#FTPPort#"  directory="directoryName" />

```





## Related System Properties / Environment Variables

- [LUCEE_FTP_DEBUG](../../recipes/environment-variables-system-properties.md#lucee_ftp_debug) - Boolean which enables debug logging to the console for FTP
  ***Type:** boolean, **Default:** false*
- [LUCEE_JSCH_DEBUG](../../recipes/environment-variables-system-properties.md#lucee_jsch_debug) - Boolean which enables debug logging to the console for SFTP
  ***Type:** boolean, **Default:** false*



# Categories

[Internet Protocols](../../categories/protocols.md)

# See Also

[<cfhttp>](http.md)