# <cfform>

Builds a form with CFML custom control tags that provide more functionality than standard
HTML form input elements (XML and Flash type not supported).

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [Form Tags for Jakarta EE (Lucee 7+)](https://download.lucee.org/#FAD67145-E3AE-30F8-1C11A6CCF544F0B7)

```
<cfform
    name=string
    action=string
    preserveData=boolean
    enableCAB=boolean
    target=string
    method=string
    encType=string
    passThrough=any
    codeBase=string
    archive=string
    scriptSrc=string
    id=string
    onError=string
    onReset=string
    onLoad=string
    onSubmit=string
    style=string
    class=string
    format=string
    skin=string
    width=string
    height=string
    preloader=boolean
    timeout=number
    wMode=string
    accessible=boolean
    accept=string
    acceptcharset=string
    title=string
    dir=string
    lang=string
    onclick=string
    ondblclick=string
    onmousedown=string
    onmouseup=string
    onmouseover=string
    onmousemove=string
    onmouseout=string
    onkeypress=string
    onkeyup=string
    onkeydown=string
><!--- body ---></cfform>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | No | A name for the form you are creating. |  |
| action | string | No | The name of the page that executed when the form is submitted for processing. |  |
| target | string | No | The name of the window or window frame to which the form output is sent. |  |
| method | string | No | other than post will ignored |  |
| encType | string | No | The MIME type used to encode data sent by the POST method. The default value is application/x-www-form-urlencoded. It is recommended that you accept the default value. This attribute is included for compatibility with the HTML form tag. |  |
| passThrough | any | No | Used for HTML attributes that are not explicitly supported by cfform. If you specify an attribute and value, they are passed to the HTML code that is generated for the cfinput tag. |  |
| codeBase | string | No | URL for a downloadable JRE plugin (for Internet explorer only). Default is /CFIDE/classes/cf-j2re-win.cab. |  |
| archive | string | No | URL for a downloadable Java classes for controls. |  |
| scriptSrc | string | No | Specifies the URL, relative to the web root, of the directory that contains the cfform.js file with the client-side JavaScript used by this tag and its child tags. For XML format forms, this directory is also the default directory for XSLT skins. |  |
| id | string | No | HTML id passed through to form tag created, only used for type html. |  |
| onError | string | No | The name of a JavaScript function that runs if a form submission fails. |  |
| onReset | string | No | JavaScript to execute when the user clicks a reset button. |  |
| onLoad | string | No | JavaScript to execute when the form loads. |  |
| onSubmit | string | No | JavaScript function to execute after other input validation returns. Use this attribute to execute JavaScript for preprocessing data before the form is submitted |  |
| style | string | No | Styles to apply to the form. In HTML or XML format, Lucee passes the style attribute to the browser or XML. In Flash format, must be a style specification in CSS format (XML and Flash type not supported). |  |
| class | string | No | passed through to form tag created, only used for type html. |  |
| format | string | No | passed through to form tag created, only used for type html. |  |
| accept | string | No | passed through to form tag created, only used for type html. |  |
| acceptcharset | string | No | passed through to form tag created, only used for type html. |  |
| title | string | No | passed through to form tag created, only used for type html. |  |
| dir | string | No | passed through to form tag created, only used for type html. |  |
| lang | string | No | passed through to form tag created, only used for type html. |  |
| onclick | string | No | passed through to form tag created, only used for type html. |  |
| ondblclick | string | No | passed through to form tag created, only used for type html. |  |
| onmousedown | string | No | passed through to form tag created, only used for type html. |  |
| onmouseup | string | No | passed through to form tag created, only used for type html. |  |
| onmouseover | string | No | passed through to form tag created, only used for type html. |  |
| onmousemove | string | No | passed through to form tag created, only used for type html. |  |
| onmouseout | string | No | passed through to form tag created, only used for type html. |  |
| onkeypress | string | No | passed through to form tag created, only used for type html. |  |
| onkeyup | string | No | passed through to form tag created, only used for type html. |  |
| onkeydown | string | No | passed through to form tag created, only used for type html. |  |

# Examples

```cfml
<cfform name="mycfform">
    -- year --
    <br />
    <cfselect name="year" enabled=true style="color:blue;" size=2>
        <option name="0" selected=true>--2024--</option>
        <option name="1">--2023--</option>
        <option name="3">--2022--</option>
        <option name="2">--2021--</option>
    </cfselect> <br />
    -- color --
    <br />
    <cfselect name="color" >
        <option name="0">--red--</option>
        <option name="1">--green--</option>
        <option name="2">--blue--</option>
    </cfselect>
</cfform>
```








# Categories

[Ajax features](../../categories/ajax.md)

# See Also

[<cfinput>](input.md), [<cfselect>](select.md), [<cfslider>](slider.md), [<cftextarea>](textarea.md)