# <cffinally>

Used inside a cftry tag.
Code in the cffinally block is processed after the main cftry code and, if an exception occurs, the cfcatch code.
The cffinally block code always executes, whether or not there is an exception.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cffinally><!--- body ---></cffinally>
```

*This tag does not use any attributes.*

# Examples

### Tag Example

```cfml
<cftry>
  <cfset a = 2/0>
  <cfdump var="#a#" />
  <cfcatch type="any">
    Caught an error.
  </cfcatch>
  <cffinally>
    This is from cffinally.
  </cffinally>
</cftry>
```

### Script Example

```cfml
      try{
          a = 2/0
          writeDump("#a#");
        }
        catch(any e){
            writeOutput("Caught an error.");
        }
        finally{
			writeOutput("This is from finally.");   
        }
```








# See Also

[<cfcatch>](catch.md), [<cfthrow>](throw.md), [<cftry>](try.md)