# <cffile>

Handles all common interactions with files.

The attributes you use with cffile depend on the value of the action attribute.

For example, if the action = "write", use the attributes associated with writing a text file.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cffile
    storeAcl=object
    action=info|move|rename|copy|delete|read|readBinary|write|append|upload|uploadAll|touch
    serverPassword=string
    source=string
    attributes=string
    destination=string
    mode=string
    fileField=string
    charset=string
    nameConflict=string
    accept=string
    strict=boolean
    createPath=boolean
    file=string
    variable=string
    output=any
    cachedWithin=object
    addNewLine=boolean
    fixNewLine=boolean
    result=string
    allowedExtensions=any
    blockedExtensions=any
><!--- body ---></cffile>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| storeAcl | object | No | Access Control List (ACL) to use for new files. Can be a either a string (`"authenticated-read"`, `"private"`, `"public-read"`, or `"public-read-write"`), or an array of structs where each struct represents a permission or grant. Example: ```[{email="xxx@yyy.com", permission="full_control"}, {group="all", permission="read"}]``` Defaults to the value specified in the application's `this.s3.acl`, which is `"public"` if unspecified. *Alias: acl* |  |
| action | string | Yes | Type of file manipulation that the tag performs. - info [FileInfo()](../functions/fileinfo.md) - move [FileMove()](../functions/filemove.md) - rename - copy [FileCopy()](../functions/filecopy.md) - delete [FileDelete()](../functions/filedelete.md) - read [FileRead()](../functions/fileread.md) - readbinary [FileReadBinary()](../functions/filereadbinary.md) - write [FileWrite()](../functions/filewrite.md) - append [FileAppend()](../functions/fileappend.md) - upload [FileUpload()](../functions/fileupload.md) - uploadall [FileUploadAll()](../functions/fileuploadall.md) - touch [FileTouch()](../functions/filetouch.md) **Note:** action upload return the [ status of the upload operation ](../../guides/Various/file-upload-result.md) as a struct after the file upload |  |
| serverPassword | string | No | allow you to access filesystem, also when access is denied for your context |  |
| source | string | No | Absolute pathname of file on web server. On Windows, use backward slashes; on UNIX, use forward slashes. |  |
| attributes | string | No | One attribute (Windows) or a comma-delimited list of attributes (other platforms) to set on the file. If omitted, the file's attributes are maintained. |  |
| destination | string | No | Absolute pathname of directory or file on web server. |  |
| mode | string | No | Applies only to Solaris and HP-UX. Permissions. Octal values of UNIX chmod command. Assigned to owner, group, and other, respectively. |  |
| fileField | string | No | Name of form field used to select the file. |  |
| charset | string | No | Character set name for the file contents. |  |
| nameConflict | string | No | Action to take if filename is the same as that of a file in the directory. - skip - error - overwrite - makeunique - forceunique |  |
| accept | string | No | list of supported extensions or/and mimetypes. |  |
| strict | boolean | No | for action "upload" and "uploadAll": if set to true (default), only mimetypes are supported. |  |
| createPath | boolean | No | for action "append", "touch" and "write": if set to false (default), expects all parent directories to exist, true will generate necessary directories |  |
| file | string | No | Absolute pathname of file on web server. |  |
| variable | string | No | Name of variable to contain contents of text file. |  |
| output | any | No | Content of the file to be created. |  |
| cachedWithin | object | No | possible values are: - String "request": If original content was created within the current request, cached content data is used. - a timespan (created with function CreateTimeSpan): If original content date falls within the time span, cached content data is used. To use cached data, the tag must be called with the exact same arguments. Only used by action "read" and "readbinary" |  |
| addNewLine | boolean | No | Yes: appends newline character to text written to file |  |
| fixNewLine | boolean | No | - **true:** changes embedded line-ending characters in string variables to operating-system specific line endings - **false:** (default) do not change embedded line-ending characters in string variables. |  |
| result | string | No | Name of the result value (default:cffile) |  |
| allowedExtensions | any | No | String list or string array of extensions allowed, this overwrites any other setting including the attribute [blockedExtensions] and settings done for example in the Application.cfc. *Alias: allowextension, allowedextension* |  |
| blockedExtensions | any | No | String list or string array of extensions blocked, this overwrites any setting done for example in the Application.cfc. *Alias: blockextension, blockedextension* |  |

# Examples

### File Upload

```cfml
<cffile action="upload" destination="destination-directory" fileField="form.fileData" nameconflict="overwrite">
```

### File Write

```cfml
<cffile action="write" file="#expandPath("./myFile.txt")#" output="Content that you need to write.">
```

### File Read

```cfml
<cffile action="read" file="#expandpath("./myfile.pdf")#" variable="myfile">
```

### File Rename

```cfml
<cffile action="rename" source="#expandPath("./myFile.pdf")#" destination="#expandPath("./myNewFileName.pdf")#" attributes="normal">
```

### File Info

```cfml
<cffile action="info" file="#expandPath("./myFile.txt")#" variable="fileInfo">
```

### File Move

```cfml
<cffile action="move" source="#expandpath("./myfile.pdf")#" destination="#expandpath("./some/moveditems/")#">
```

### File Copy

```cfml
<cffile action="copy" source="#expandpath("./myfile.pdf")#" destination="#expandpath("./some/copypath/")#">
```

### File Delete

```cfml
<cffile action="delete" file="#expandpath("./some/moveditems/")#">
```

### File ReadBinary

```cfml
<cffile action="readBinary" file="#expandPath("./myFile.txt")#" variable="fileData">
```

### File Append

```cfml
<cffile action="append" file="#expandPath("./myFile.txt")#" output="Content to append">
```

### File Touch

```cfml
<cffile action="touch" file="#expandPath("./myFile.txt")#" createpath=true>
```

### Script Examples

### File Info

```cfml
result = fileInfo(getTempFile(getTempDirectory(),"demo"));
```

### File Upload

```cfml
result = fileupload(getTempDirectory(),"form.fileData"," ","makeunique");
```

### File Write

```cfml
filewrite(file="#expandPath("./myFile.txt")#" data="Content that you need to write.");
```

### File Read

```cfml
result = fileread(file="#expandPath("./myFile.txt")#");
```

### File ReadBinary

```cfml
binaryContent = fileReadBinary(expandPath('./image.jpg'));
```

### File Append

```cfml
fileAppend("path/to/file", "new content to append")
```

### File Rename

```cfml
filemove(source="#expandPath("./myFile.txt")#",destination="#expandPath("./myNewFileName.txt")#");
```

### File Move

```cfml
filemove(source="#expandPath("./myFile.txt")#",destination="#expandPath("./myNewFileName.txt")#");
```

### File Copy

```cfml
filecopy(source="#expandPath("./myNewFileName.txt")#",destination="#expandPath("./some/moved/")#");
```

### File Delete

```cfml
filedelete(source="#expandPath("./myFile.txt")#");
```

### File Touch

```cfml
fileTouch( file="#expandPath("./myFile.txt")#",createPath=true );
```





## Related System Properties / Environment Variables

- [LUCEE_FILEUPLOAD_ALLOW_MIMETYPE_DETECTION](../../recipes/environment-variables-system-properties.md#lucee_fileupload_allow_mimetype_detection) - Boolean value that enables using Tika to detect the mime type for unknown file uploads
  ***Type:** boolean, **Default:** true, **Introduced:** 7.0.0.312*
- [LUCEE_RESOURCE_CHARSET](../../recipes/environment-variables-system-properties.md#lucee_resource_charset) - Default character set for reading from/writing to various resources (files)
  ***Type:** string, **Default:** system charset*
- [LUCEE_TAG_POPULATE_LOCALSCOPE](../../recipes/environment-variables-system-properties.md#lucee_tag_populate_localscope) - Controls whether tags like cflock and cfquery populate their default result variables to local scope when inside a function. When `true`, variables go to local scope. When `false`, restores pre LDEV-5416 behavior where variables go to variables scope
  ***Type:** boolean, **Default:** true, **Introduced:** 7.0.1.13*
- [LUCEE_UPLOAD_BLOCKLIST](../../recipes/environment-variables-system-properties.md#lucee_upload_blocklist) - Default block list for the tag cffile action=`upload`. A comma-separated list of extensions that are allowed when uploading files via forms
  ***Type:** string*



# Categories

[Cache](../../categories/cache.md), [File handling](../../categories/files.md), [Core CFML Language](../../categories/core.md)

# See Also

[File Upload Operation Result](../../guides/Various/file-upload-result.md), [FileUpload()](../functions/fileupload.md), [FileUploadAll()](../functions/fileuploadall.md), [<cffileupload>](fileupload.md)