# <cfexecute>

Enables developers to execute a process on a server computer.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfexecute
    name=string
    arguments=any
    outputFile=string
    timeout=number
    terminateOnTimeout=boolean
    variable=string
    errorFile=string
    errorVariable=string
    directory=string
    environment=struct
    result=string
    exitCodeVariable=string
    onProgress=any
    onError=any
><!--- body ---></cfexecute>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | Yes | The full pathname of the application to execute. Note: On Windows, you must specify the extension as part of the application's name. For example, myapp.exe, |  |
| arguments | any | No | Command-line arguments passed to the application. - arguments as a string - arguments as an Array (recommended) |  |
| outputFile | string | No | The file to which to direct the output of the program. If not specified, the output is displayed on the page from which it was called. |  |
| timeout | number | No | Indicates how long, in seconds, the executing thread waits for the spawned process. A timeout of 0 is equivalent to the non-blocking mode of executing. A very high timeout value is equivalent to a blocking mode of execution. The default is 0; therefore, the thread spawns a process and returns without waiting for the process to terminate.If no output file is specified, and the timeout value is 0, the program output is discarded. |  |
| terminateOnTimeout | boolean | No | terminate execution of process when timeout occur. Defaults to false. |  |
| variable | string | No | Variable in which to put program output. If no output file or variable attribute is specified, output is displayed on page from which it was called. |  |
| errorFile | string | No | The file to which to direct the error stream of the program. If neither errorFile nor errorVariable is specified, the error stream is discarded. |  |
| errorVariable | string | No | Variable in which to put program error stream output. If neither errorFile nor errorVariable is specified, the error stream is discarded. |  |
| directory | string | No | The working directory in which to execute the command |  |
| environment | struct | No | An struct of environment variables |  |
| result | string | No | The name of a variable to place the return struct, containing [ output, error, exitCode ] |  |
| exitCodeVariable | string | No | Variable in which to put the exit code value. |  |
| onProgress | any | No | A UDF which receives two arguments, the progressive output and the java Process instance for the execution. If defined, output to the other variables will be null. The java Process instance can be used to interact with the executing process, i.e. via `getOutputSteam()`. [Java Process](https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/lang/Process.html) Returning false from the Listener will cancel the process execution |  |
| onError | any | No | A UDF Listener which receives a single argument, output. Optional, If a OnProgress Listener is defined, but no onError listener, the error stream is redirected to the onProgress Listener. Returning false from the Listener will cancel the process execution |  |

# Examples

### Simple example for cfexecute

```cfml
<cfexecute name="C:\Windows\System32\netstat.exe"
            arguments="-e"
            outputFile="C:\Temp\output.txt"
            timeout="1">
</cfexecute>
```

### Executing a shell command on Linux

```cfml
<cfscript>
	env = { "LUCEE": "rocks" }; // lucee 7+
	exe ="bash";
	// args as a string
	args = "-c 'set'";  // or ls etc
	cfexecute(name=exe, timeout="1", arguments=args , environment=env, variable="result");	
</cfscript>
```

### Executing a shell command on Windows

```cfml
<cfscript>
	env = { "LUCEE": "rocks" }; // lucee 7+
	exe = "cmd";
	// args as an array
	args = ["/c", "set"]; // or dir etc
	cfexecute(name=exe, timeout="1", arguments=args , environment=env, variable="result");
</cfscript>
```

### Example for cfexecute with onprogress & onerror (Introduced: 7.0.0.188)

```cfml
<cfscript>
    function handleProgress(line, process) {
        writeOutput(">> " & line & "<br>");
        return true; // Continue processing
    }
    function onErrorListener ( errorOutput ){
        writeOutput("ERROR " & err);
        return false; //cancel the process
    };
        // Execute the "dir" command
    cfexecute(
        name="cmd",//windows command line
        arguments="/c dir", // "/c" ensures the command runs and exits
        result="local.result", // Captures the output of the command 
        directory="C:\Users", // Specify the directory to list
        onError=onErrorListener, // Callback function for error handling
        onprogress =handleProgress, // Callback function for progress
        timeout=10 // Set a timeout to prevent hanging
    ); 
</cfscript>
```








# Categories

[Core CFML Language](../../categories/core.md)