# <cfelseif>

Use this tag within [<cfif>](if.md) tags and optionally, together with other [<cfelseif>](elseif.md) tags and a final [<cfelse>](else.md).

[<cfelseif>](elseif.md) lets you create compound conditional statements in CFML.

The [<cfelseif>](elseif.md) tag will handle cases not handled by the original [<cfif>](if.md) or preceding [<cfelseif>](elseif.md)
tags.

The value in the [<cfelseif>](elseif.md) tag can be any expression.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfelseif #boolean condition#>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| condition | boolean | No | Expression condition |  |

# Examples

### Tag format

```cfml
<cfif isArray(SERVER)>
	<cfset result="It is in Array format">
<cfelseif(isStruct(SERVER))>
	<cfset result="It is in Structure format">
<cfelse>
	<cfset result ="Other than struct & Array">
</cfif>
<cfdump var="#result#" />
```

### Script format

```cfml
	//script format
	numb=1
	if(numb gt 1){
		writeOutput("It is greater than 1 ");
	}else if(numb eq 1){
		writeOutput("It is equal to 1 ");
	}else{
		writeOutput("It is not greater than or equal to 1 ");
	}
```








# Categories

[Core CFML Language](../../categories/core.md)

# See Also

[<cfelse>](else.md), [<cfif>](if.md)