# <cfdump>

Outputs the elements, variables and values of most kinds of CFML objects.

Very useful for debugging.

You can display the contents of simple and complex variables, objects, components, user-defined functions, and other elements.

This tag **may** have a body.
This tag has no [<cfscript>](script.md) support or it uses a different syntax.

```
<cfdump
    var=any
    eval=string
    expand=boolean
    label=string
    top=number
    showUDFs=boolean
    show=string
    output=string
    metainfo=boolean
    keys=number
    hide=string
    format=string
    abort=boolean
    async=boolean
    enabled=boolean
    flush=boolean
><!--- body ---></cfdump>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| var | any | No | Variable to display. Enclose a variable name in pound signs. |  |
| eval | string | No | name of the variable to display, also used as label, when no label defined. |  |
| expand | boolean | No | expands views |  |
| label | string | No | header for the dump output. |  |
| top | number | No | The number of rows to display. |  |
| showUDFs | boolean | No | show UDFs in cfdump output. |  |
| show | string | No | show column or keys. |  |
| output | string | No | Where to send the results: - **browser:** the result is written to the browser response stream (default). - **console:** the result is written to the console (System.out). - **debug:** the result is written to the debugging logs, when debug is enabled. - **false:** output will not be written, effectively disabling the dump (**this is currently not implemented**, use `enabled=false` instead) Otherwise, this is value is treated as filename to write/append the dump outputs into, unless left blank. |  |
| metainfo | boolean | No | Includes information about the query in the cfdump results. |  |
| keys | number | No | For a structure, number of keys to display. |  |
| hide | string | No | hide column or keys. |  |
| format | string | No | specify the output format of the dump, the following formats are available by default: - **html:** the default browser output - **text:** this is the default when outputting to console and plain text in the browser - **classic:** classic view with HTML/CSS/JavaScript - **simple:** no formatting in the output You can use your custom style by creating a corresponding file in the lucee/dump/skins folder. Check the folder for examples. |  |
| abort | boolean | No | stops further processing of request. |  |
| async | boolean | No | if true and output is not to browser, Lucee builds the output in a new thread that runs in parallel to the thread that called the dump. please note that if the calling thread modifies the data before the dump takes place, it is possible that the dump will show the modified data. |  |
| enabled | boolean | No | dumps are enabled by default, pass false to short circuit a dump execution and effectively disable it |  |
| flush | boolean | No | flushes the response stream after the dump |  |

# Examples

### Simple example with cfdump

```cfml
<!--- You can dump any thing here. Easy to see the content of complex data type--->
<cfdump var="#getTimeZoneInfo()#" label="Tag label"/>
```








# Categories

[Core CFML Language](../../categories/core.md), [Debugging](../../categories/debugging.md)

# See Also

[Console logging using SystemOutput](../../recipes/console-logging.md), [Dump()](../functions/dump.md), [WriteDump()](../functions/writedump.md), [Custom CFDUMP Templates](../../guides/Various/TIPS/TIPS-dump-template.md)