# <cfdocumentsection>

Divides a PDF document into sections.

By using this tag in conjunction with a [<cfdocumentitem>](documentitem.md) tag, each section can have unique headers, footers, and page numbers.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [PDF Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#66E312DD-D083-27C0-64189D16753FD6F0)

```
<cfdocumentsection
    marginbottom=number
    marginleft=number
    marginright=number
    margintop=number
    orientation=string
    src=string
    srcfile=string
    mimetype=string
    name=string
    authUser=string
    authPassword=string
    userAgent=string
><!--- body ---></cfdocumentsection>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| marginbottom | number | No | Specifies the bottom margin in inches (default) or centimeters. To specify the bottom margin in centimeters, include the unit="cm" attribute in the parent cfdocument tag. |  |
| marginleft | number | No | Specifies the left margin in inches (default) or centimeters. To specify the left margin in centimeters, include the unit="cm" attribute in the parent cfdocument tag. |  |
| marginright | number | No | Specifies the right margin in inches (default) or centimeters. To specify the right margin in centimeters, include the unit="cm" attribute in the parent cfdocument tag. |  |
| margintop | number | No | Specifies the top margin in inches (default) or centimeters. To specify the top margin in centimeters, include the unit="cm" attribute in the parent cfdocument tag. |  |
| orientation | string | No | Page orientation. Can be "landscape" or "portrait". Defaults to the orientation of the enclosing `<cfdocument>`. |  |
| src | string | No | define a url or a relative path on the local system to a file that should be transferred to a pdf |  |
| srcfile | string | No | define an absolute path to a file that should be transferred to a pdf |  |
| mimetype | string | No | mimetype of the source (when attribute src or srcfile are defined) |  |
| name | string | No | Bookmark name for the section |  |
| authUser | string | No | User name sent to the target URL for Basic Authentication. Combined with password to form a base64 encoded string that is passed in the Authenticate header. Does not provide support for Integrated Windows, NTLM, or Kerberos authentication. |  |
| authPassword | string | No | Password sent to the target URL for Basic Authentication. Combined with username to form a base64 encoded string that is passed in the Authenticate header. Does not provide support for Integrated Windows, NTLM, or Kerberos authentication. |  |
| userAgent | string | No | Text to put in the HTTP User-Agent request header field. Used to identify the request client software. |  |

# Examples

### Simple Examples

```cfml
<cfdocument format="pdf">
    <cfdocumentsection>
        <cfdocumentitem type="header">
            <h2><i>Example section-1 Header</i></h2>
        </cfdocumentitem>
        <h1>Welcome to Lucee</h1>
        <p>Example for <b>CfdocumentSection</b></p>
        <h2><i>Example section-1 body</i></h2>
        <cfdocumentitem type="footer">
            <h2><i>Example section-1 footer</i></h2>
        </cfdocumentitem>
    </cfdocumentsection>
    <cfdocumentsection>
        <cfdocumentitem type="header">
            <h2><i>Example section-2 Header</i></h2>
        </cfdocumentitem>
        <h2><i>Example section-2 body</i></h2>
        <cfdocumentitem type="footer">
            <h2><i>Example section-2 footer</i></h2>
        </cfdocumentitem>
    </cfdocumentsection>
</cfdocument>

```








# Categories

[PDFs](../../categories/pdf.md)

# See Also

[<cfdocument>](document.md)