# <cfdocumentitem>

Specifies action items for a PDF document created by the cfdocument tag.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [PDF Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#66E312DD-D083-27C0-64189D16753FD6F0)

```
<cfdocumentitem
    type=string
    name=string
    evalAtPrint=boolean
><!--- body ---></cfdocumentitem>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| type | string | Yes | Specifies the action: - pagebreak (starts a new page at the location of the tag) - header (uses the text between in the body of the tag as the running header) - footer (uses the text between the body of the tag as the running footer) - bookmark (set a bookmark, use the attribute name to define the name of the bookmark) |  |
| name | string | No | used only for type bookmark, name of the bookmark to define. |  |

# Examples

### Simple example for cfdocumentitem

```cfml
<cfdocument format="pdf">
	<h1>Welcome to Lucee</h1>
	<h5>Example Page</h5>
	<p>Example for <b>CfdocumentItem</b></p>
	<cfdocumentitem type="header">
		<h2><i>Example Header</i></h2>
	</cfdocumentitem>
	<cfdocumentitem type="footer">
		<h2><i>Example footer</i></h2>
	</cfdocumentitem>
</cfdocument>
```








# Categories

[PDFs](../../categories/pdf.md)

# See Also

[<cfdocument>](document.md)