# <cfdocument>

Creates a PDF document from a text block containing CFML and HTML.

Note that Word and Excel conversion is not available.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [PDF Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#66E312DD-D083-27C0-64189D16753FD6F0)

```
<cfdocument
    backgroundvisible=boolean
    encryption=String
    filename=String
    fontembed=string
    fontdirectory=string
    format=string
    page=any
    margin=any
    marginbottom=number
    marginleft=number
    marginright=number
    margintop=number
    mimetype=string
    name=string
    orientation=string
    overwrite=boolean
    ownerpassword=string
    pageheight=number
    pagewidth=number
    pagetype=string
    permissions=string
    scale=number
    src=string
    srcfile=string
    type=string
    unit=string
    userpassword=string
    proxyHost=string
    proxyPort=number
    proxyUser=string
    proxyPassword=string
    bookmark=boolean
    htmlbookmark=boolean
    localUrl=boolean
    authUser=string
    authPassword=string
    userAgent=string
    saveAsName=string
><!--- body ---></cfdocument>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| encryption | String | No | define if the output should be encrypted and how deep |  |
| filename | String | No | name for output file, if not defined output will be written to response stream |  |
| fontembed | string | No | define if fonts will embedded with the file |  |
| fontdirectory | string | No | directory that contains additional font files (.ttf) and a pd4fonts.properties to describe them. **Note**: Classic engine works using the font-family-name from pd4fonts.properties file. Modern (Flying saucer) engine works using the font-family-name from the .ttf file with the same case. |  |
| format | string | No | format of the created file |  |
| page | any | No | Specifies the page info in a struct like this {width:10, height:5, type:A4} |  |
| margin | any | No | Specifies the margin in inches (default), centimeters or points. The attribute unit controls the type. possible values is a number, so margin is the same all around, or a struct like this {top:1,bottom:1,left:2,right:2} |  |
| marginbottom | number | No | Specifies the bottom margin in inches (default) or centimeters. To specify bottom margin in centimeters, include the unit=cm attribute. |  |
| marginleft | number | No | Specifies the left margin in inches (default) or centimeters. To specify left margin in centimeters, include the unit=cm attribute. |  |
| marginright | number | No | Specifies the right margin in inches (default) or centimeters. To specify right margin in centimeters, include the unit=cm attribute. |  |
| margintop | number | No | Specifies the top margin in inches (default) or centimeters. To specify top margin in centimeters, include the unit=cm attribute. |  |
| mimetype | string | No | mimetype of the source (when attribute src or srcfile are defined) |  |
| name | string | No | name of a variable to store the output in it *Alias: variable* |  |
| orientation | string | No | Page orientation. Can be "landscape" or "portrait". Defaults to "portrait". |  |
| overwrite | boolean | No | define if an existing file will be overwritten or not |  |
| ownerpassword | string | No | Specifies an owner password (format="PDF" only). |  |
| pageheight | number | No | used when pagetype is custom |  |
| pagewidth | number | No | used when pagetype is custom |  |
| pagetype | string | No | defined the used format for the page (,legal,letter,A4,A5,B4,B5,B4-JIS,B5-JIS and custom) |  |
| permissions | string | No | Sets the permissions for the document - AllowPrinting - AllowModifyContents - AllowCopy - AllowModifyAnnotations - AllowFillIn - AllowScreenReaders - AllowAssembly - AllowDegradedPrinting |  |
| src | string | No | define a url or a relative path on the local system to a file that should be transferred to a pdf |  |
| srcfile | string | No | define an absolute path to a file that should be transferred to a pdf |  |
| type | string | No | Specifies which engine should be used to render the document. Options are: - classic - modern (Available since PDF Extension version 1.0.0.92) Defaults to the Application's `this.pdf.type` setting (which defaults to "modern"). |  |
| unit | string | No | set the unit for pageheight, pagewidth, and margin... |  |
| userpassword | string | No | Specifies a user password (format="PDF" only). Defaults to "empty" if is not set, and encryption is set to 40 bit or 128 bit. |  |
| proxyHost | string | No | alias for proxyHost *Alias: proxyserver* |  |
| proxyPort | number | No | The port number on the proxy server from which the object is requested. Default is 80. When used with resolveURL, the URLs of retrieved documents that specify a port number are automatically resolved to preserve links in the retrieved document. |  |
| proxyUser | string | No | When required by a proxy server, a valid username. |  |
| proxyPassword | string | No | When required by a proxy server, a valid password. |  |
| bookmark | boolean | No | Specifies whether bookmarks are created in the document |  |
| htmlbookmark | boolean | No | If true, it is possible to convert outlines to a list of named anchors (`<a name="anchor_id">label</a>`) or a headings structure (`<h1>`...`<h6>`). Transforming of HTML hyperlinks to PDF hyperlinks (if not explicitly disabled). Hyperlink jumps within the same document are supported as well |  |
| localUrl | boolean | No | Specifies whether to retrieve image files directly from the local drive |  |
| authUser | string | No | User name sent to the target URL for Basic Authentication. Combined with password to form a base64 encoded string that is passed in the Authenticate header. Does not provide support for Integrated Windows, NTLM, or Kerberos authentication. |  |
| authPassword | string | No | Password sent to the target URL for Basic Authentication. Combined with username to form a base64 encoded string that is passed in the Authenticate header. Does not provide support for Integrated Windows, NTLM, or Kerberos authentication. |  |
| userAgent | string | No | Text to put in the HTTP User-Agent request header field. Used to identify the request client software. |  |
| saveAsName | string | No | (format="PDF" only) The filename that appears in the SaveAs dialog when a user saves a PDF file written to the browser. |  |

# Examples

### Simple example for cfdocument

```cfml
<cfdocument format="pdf">
	<h1>Welcome to Lucee</h1>
	<h5>Example Page</h5>
	<p>Example for <b>Cfdocument</b></p>
</cfdocument>
```








# Categories

[PDFs](../../categories/pdf.md)

# See Also

[PDF Engine - CFDOCUMENT using Flying Saucer](../../recipes/pdf-engine-flying-saucer.md), [<cfdocumentitem>](documentitem.md), [<cfdocumentsection>](documentsection.md), [<cfpdf>](pdf.md)