# <cfdistributedlock>

Redis based [<cflock>](lock.md) that can be used across servers, i.e. in a clustered, or load balanced environment

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [Redis driver](https://download.lucee.org/#60772C12-F179-D555-8E2CD2B4F7428718)

```
<cfdistributedlock
    name=string
    cache=string
    timeout=numeric
    throwOnTimeout=boolean
    logOnTimeout=boolean
    amount=numeric
    expires=numeric
    bypass=boolean
><!--- body ---></cfdistributedlock>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | Yes | Specifies the name of the lock. Only {amount} (see attribute amount) request(s) can execute inside this tag with a given name. Therefore, providing the name attribute allows for synchronizing access to resources from different parts of an application. Lock names are global to a server. They are shared between applications and user sessions, but not across clustered servers. |  |
| cache | string | Yes | name of the redis cache used to lock. |  |
| timeout | numeric | No | Specifies the maximum amount of time in seconds, to wait to obtain a lock. If a lock can be obtained within the specified period, execution continues inside the body of the tag. Otherwise, the behavior depends on the value of the `throwOnTimeout` attribute. The value must be at least 0.01. |  |
| throwOnTimeout | boolean | No | Yes or No. Specifies how timeout conditions are handled. If the value is Yes, an exception is generated to provide notification of the timeout. If the value is No, execution continues after the tag. Default is No. |  |
| logOnTimeout | boolean | No | In case we reach a timeout, and the value is set to yes, we log this to the application.log. Default is Yes. |  |
| amount | numeric | No | Defines the amount of parallel threads allowed within the lock, default is 1. |  |
| expires | numeric | No | The time in seconds a lock remains in case it not get released, by default this is 10 minutes. |  |
| bypass | boolean | No | If set to true the lock is not done at all. |  |

# Examples

*There are currently no examples for this tag.*








# Categories

[Cache](../../categories/cache.md), [Redis](../../categories/redis.md)

# See Also

[<cflock>](lock.md)