# <cfdirectory>

Handles interactions with directories.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfdirectory
    action=list|create|delete|forceDelete|rename|copy|info
    listInfo=string
    storeAcl=object
    storeLocation=string
    type=string
    serverPassword=string
    directory=string
    name=string
    filter=any
    filterDelimiters=string
    mode=string
    sort=string
    newDirectory=string
    destination=string
    recurse=boolean
    nameConflict=string
    createPath=boolean
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| action | string | No | Defines the action to be taken with directory(ies) specified in directory. - list [DirectoryList()](../functions/directorylist.md) - create [DirectoryCreate()](../functions/directorycreate.md) - delete [DirectoryDelete()](../functions/directorydelete.md) - rename [DirectoryRename()](../functions/directoryrename.md) - copy [DirectoryCopy()](../functions/directorycopy.md) - forcedelete | list |
| listInfo | string | No | - **all:** includes all information in the result set. - **name:** includes only filenames in the result set. |  |
| storeAcl | object | No | An array of struct where each struct represents a permission or grant. Example: [{email="xxx@yyy.com", permission="full_control"}, {group="all", permission="read"}] *Alias: acl* |  |
| storeLocation | string | No | Only used for S3 Resources. The location of the created bucket/object. The location can either be EU,US or US-WEST. The default location is US. *Alias: storage* |  |
| type | string | No | - **file:** includes only filenames. - **dir:** includes only directory names. - **all:** includes both filenames and directory names. |  |
| serverPassword | string | No | Allow you to access filesystem, also when access is denied for your context |  |
| directory | string | Yes | The name of the directory to perform the action against. |  |
| name | string | No | Required for action = "list". Ignored by all other actions. Name of output query for directory listing. *Alias: variable* |  |
| filter | any | No | Optional for action = "list". Ignored by all other actions. Can be either: - a wildcard filter,e.g. "m*" - or a UDF/Closure which accepts the file/directory name and returns a Boolean value to indicate whether that item should be included in the result or not. |  |
| filterDelimiters | string | No | Optional when passing a filter pattern. This value is used as a delimiter for the patterns. Default is the pipe "\|" character. |  |
| mode | string | No | Used with action = "Create" to define the permissions for a directory on UNIX and Linux platforms. Ignored on Windows. Options correspond to the octal values of the UNIX chmod command. From left to right, permissions are assigned for owner, group, and other. |  |
| sort | string | No | Optional for action = "list". Ignored by all other actions. The query columns by which to sort the directory listing. Any combination of columns from query output can be specified in comma-separated list. You can specify ASC (ascending) or DESC (descending) as qualifiers for column names. ASC is the default |  |
| newDirectory | string | No | Required for action = "rename". Ignored by all other actions. The new name of the directory specified in the directory attribute. |  |
| destination | string | No | Required for action = "copy". Ignored by all other actions. Path of the destination directory. If not an absolute path, it is relative to the source directory. |  |
| recurse | boolean | No | Whether or not to include the content of any sub-directories |  |
| nameConflict | string | No | When used with action="copy" the possible values are: - Overwrite - Error When used with action="create" the possible values are: - Error - Skip Ignored for all other actions. |  |
| createPath | boolean | No | - true (default), automatically create any parent directories which don't exist - false, all the parent directories must already exist or an error will be thrown |  |


# Usage Notes

For ACF compatibility, on Unix Systems, the `mode` column is currently not populated for `action="list"`

<https://luceeserver.atlassian.net/browse/LDEV-2118>

# Examples

### Simple format for cfdirectory

### Directory Create

```cfml
<cfdirectory action="create" directory="path of directory">
```

### Directory List

```cfml
<cfdirectory action = "list" directory = "pathOfDirectory" name = "list">
```

### Directory Copy

```cfml
<cfdirectory action = "copy" directory = "/pathOfDirectory" destination = "/pathOfDirector" nameconflict = "Overwrite" recurse = "true">
```

### Directory Rename

```cfml
<cfdirectory action = "rename" directory = "pathOfDirectory" newDirectory = "renameOfDirectory">
```

### Directory Delete

```cfml
<cfdirectory action = "Delete" directory = "pathOfDirectory" >
```

### Directory Forcedelete

```cfml
<cfdirectory action = "forcedelete" directory = "pathOfDirectory" >
```





## Related System Properties / Environment Variables

- [LUCEE_RESOURCE_CHARSET](../../recipes/environment-variables-system-properties.md#lucee_resource_charset) - Default character set for reading from/writing to various resources (files)
  ***Type:** string, **Default:** system charset*



# Categories

[Core CFML Language](../../categories/core.md), [File handling](../../categories/files.md)

# See Also

[DirectoryCopy()](../functions/directorycopy.md), [DirectoryCreate()](../functions/directorycreate.md), [DirectoryDelete()](../functions/directorydelete.md), [DirectoryExists()](../functions/directoryexists.md), [DirectoryList()](../functions/directorylist.md), [DirectoryRename()](../functions/directoryrename.md)