# <cfdefaultcase>

Defines what happens within a [<cfswitch>](switch.md) statement, when none of the [<cfcase>](case.md) statements are true.

Use this tag only within a cfswitch and each cfswitch may only have one cfdefaultcase.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfdefaultcase><!--- body ---></cfdefaultcase>
```

*This tag does not use any attributes.*

# Examples

### Tag syntax 

```cfml
<cfoutput>
	<cfset expr = 2>
	<cfswitch expression="#expr#">
		<cfcase value=1>
			this is from case 2
		</cfcase>
		<cfcase value=2$3$4 delimiters="$">
			this is from case 2
		</cfcase>
		<cfdefaultcase>
			this is from default part
		</cfdefaultcase>
	</cfswitch>
</cfoutput>
```

### Script syntax

```cfml
	switch(1) {
		case 1:
			result = 1;
			break;
		case 0:
			result = 0;
			break;
		default:
			result = "defaultCase";
	}
	writeDump(result);
```








# See Also

[<cfcase>](case.md), [<cfswitch>](switch.md)