# <cfdbinfo>

Lets you retrieve information about a data source, including details about the database, tables, queries, procedures, foreign keys, indexes, and version information about the database, driver, and JDBC.

This tag supports only JDBC drivers, and does not support ODBC-based drivers, including the Microsoft Access driver.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfdbinfo
    datasource=object
    name=string
    type=string
    procedure=string
    dbname=string
    password=string
    pattern=string
    table=string
    username=string
    Filter=string
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| datasource | object | No | Datasource to use to connect to the database. |  |
| name | string | Yes | Name to use to refer to the result. *Alias: variable* |  |
| type | string | Yes | Type of information to get: - `dbNames`: database name and type - `tables`: information to all tables - `columns`: column information for tables/views, accepts wildcards like '%'' - `columns_minimal`: column information for tables/views, but no FK / PK information (**much faster**) - `version`: version information of the database - `procedures`: information to all procedures - `procedure_columns`: column information to a single procedure - `foreignKeys`: information to all foreignKeys - `index`: information to all indexes - `users`: list database users - `terms`: vendor preferred term for PROCEDURE, CATALOG and SCHEMA |  |
| procedure | string | No | Name of the procedure from which you retrieve information. |  |
| dbname | string | No | Name of the database *Alias: dbnames* |  |
| password | string | No | Password to connect to the database. |  |
| pattern | string | No | Specifies a sql filter, i.e `sys%` to retrieve information about specific tables, columns, or stored procedures |  |
| table | string | No | Name of the table from which you retrieve information. Patterns are also supported, i.e. - use `%` to fetch all columns, from every table. - use `SCHEMA.%` to fetch all columns, from every table, from a scheme. Not used for `type="tables"`, use `pattern` instead |  |
| username | string | No | User name to connect to the database. |  |
| Filter | string | No | Filter for `type="tables"` with a wildcard, defaults to all types when empty (slow, especially oracle). - "TABLE" - "VIEW" - "SYSTEM TABLE" - "GLOBAL TEMPORARY" - "LOCAL TEMPORARY" - "ALIAS" - "SYNONYM" Note: Each Database implementation has it's own supported types **Introduced: Lucee 6.0.0.76** *Alias: tabletype* |  |


# Usage Notes

Performance tips

- Using `type="columns_minimal"` is dramatically faster than `type="columns"`
- With `type="table"` using `filter="table"` is also much faster

# Examples

### CFDBINFO Syntax

```cfml
<cfdbinfo type="columns" name="db_info" datasource="lucee" dbname="tester" table="test">
```






