# <cfcookie>

Defines cookie variables, including expiration and security options.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfcookie
    name=string
    value=string
    expires=object
    secure=boolean
    path=string
    domain=string
    httpOnly=boolean
    preserveCase=boolean
    encodeValue=boolean
    sameSite=Strict|Lax|None
    partitioned=boolean
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | Yes | The name of the cookie variable. |  |
| value | string | No | The value assigned to the cookie variable. |  |
| expires | object | No | Schedules the expiration of a cookie variable. Can be specified: - as a date (as in, 10/09/97) - number of days (as in, 10, 100) - "Now" - "Never" Using Now effectively deletes the cookie from the client browser. |  |
| secure | boolean | No | Yes or No. Specifies that the variable must transmit securely. If the browser does not support Secure Socket Layer (SSL) security, the cookie is not sent. |  |
| path | string | No | URL, within a domain, to which the cookie applies; typically a directory. Only pages in this path can use the cookie. By default, all pages on the server that set the cookie can access the cookie. path = "/services/login" |  |
| domain | string | No | Domain in which cookie is valid and to which cookie content can be sent from the user's system. By default, the cookie is only available to the server that set it. Use this attribute to make the cookie available to other servers. Must start with a period. If the value is a subdomain, the valid domain is all domain names that end with this string. This attribute sets the available subdomains on the site upon which the cookie can be used. |  |
| httpOnly | boolean | No | If HttpOnly is set to true, this cookie is marked as HttpOnly, by adding the HttpOnly attribute to it. HttpOnly cookies are not supposed to be exposed to client-side scripting code, and may therefore help mitigate certain kinds of cross-site scripting attacks. |  |
| preserveCase | boolean | No | if set to true Lucee keep the original case for the name, otherwise the name is converted to a upper case string |  |
| encodeValue | boolean | No | if set to true, Lucee url encodes the given name and value if necessary. *Alias: encode* |  |
| sameSite | string | No | It will help to prevent Cross-Site Request Forgeries. Enabling this attribute on the cookie will instruct the browser to afford this cookie certain protections. Values: - strict - lax - none |  |
| partitioned | boolean | No | Used to isolate third party cookies, requires path="/" and secure="true". *Alias: encode* |  |

# Examples

### CFCOOKIE Syntax

```cfml
<cfcookie name="cookie" value=Now() domain=".local.com" path="/lucee" expires="10" httponly="yes" encodevalue="yes" samesite="strict"/>
```






