# <cfcontent>

Defines the MIME type returned by the current page.

Optionally, lets you specify the name of a file to be returned with the page.

If you specify a file or variable, that content is returned to the client and further processing stops, similar to a [<cfabort>](abort.md) tag.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfcontent
    type=string
    deleteFile=boolean
    range=boolean
    file=string
    content=binary
    variable=any
    reset=boolean
><!--- body ---></cfcontent>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| type | string | No | Defines the File/ MIME content type returned by the current page. |  |
| deleteFile | boolean | No | Yes or No. Yes deletes the file after the download operation. Defaults to No. This attribute applies only if you specify a file with the file attribute. |  |
| range | boolean | No | Yes or No. Yes allows download ranges, no forbids download range, default let it open for client. |  |
| file | string | No | The full path to the file that should be sent to the client |  |
| variable | any | No | the variable name to the content to output as binary |  |
| reset | boolean | No | Yes or No. Yes discards output that precedes the call to cfcontent. No preserves the output that precedes the call. Defaults to Yes. The reset and file attributes are mutually exclusive. If you specify a file, the reset attribute has no effect. |  |

# Examples

### Cfcontent tag format

```cfml
<cfcontent type="image/png" file="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4">
```

### Cfcontent script format

```cfml
    cfcontent(type="image/png", file="https://avatars1.githubusercontent.com/u/10973141?s=280&v=4");
```








# Categories

[Core CFML Language](../../categories/core.md)

# See Also

[<cfflush>](flush.md), [<cfheader>](header.md), [<cfhtmlhead>](htmlhead.md)