# <cfcomponent>

Creates and defines a component object; encloses functionality that you build in CFML and enclose within [<cffunction>](function.md) tags.

This tag contains one or more cffunction tags that define methods.

Code within the body of this tag, other than cffunction tags, is executed when the component is instantiated.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfcomponent
    accessors=boolean
    synchronized=boolean
    persistent=boolean
    extends=string
    implements=string
    modifier=none|final|abstract
    displayName=string
    hint=string
    output=boolean
    style=string
    namespace=string
    servicePortName=string
    serviceAddress=string
    portTypeName=string
    bindingName=string
    wsdlFile=string
    alias=string
    mappedSuperClass=boolean
    javasettings=string
><!--- body ---></cfcomponent>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| accessors | boolean | No | If set to true, enables implicit getters and setters for the component's properties. For persistent CFCs, accessors are always enabled. |  |
| synchronized | boolean | No | If set to true all calls to an instance of a component are synchronized. This setting allows a method to be executed only by one single thread at a time. |  |
| persistent | boolean | No | Specifies CFC is persistent or not |  |
| extends | string | No | Name of parent component from which to inherit methods and properties. |  |
| implements | string | No | Lists the interfaces that the component implements, specifying the set of functions that the component must provide. |  |
| modifier | string | No | Defines the type of component: `none` for a regular component, `abstract` for a component that cannot be instantiated directly and must be extended, or `final` for a component that cannot be extended by other components. |  |
| displayName | string | No | A string to be displayed when using introspection to show information about the CFC. The information appears on the heading, following the component name. If the style attribute is set to document, the displayname attribute is used as the name of the service element in the WSDL. *Alias: display* |  |
| hint | string | No | Text that displays when you use introspection to show information about the CFC. The hint attribute value appears below the component name heading. Use this attribute to describe the purpose of the component. |  |
| output | boolean | No | - true: permits component method output - false: suppresses component method output |  |
| bindingName | string | No | Specifies the name of the binding element in the WSDL. This attribute applies only when style="document". |  |
| javasettings | string | No | Specifies custom `JavaSettings` for this component. When provided, these settings override any server level JavaSettings that would otherwise be applied. Since 6.2 Lucee supports specifying Maven dependencies [JavaSettings in Application.cfc, Components and CFConfig.json](../../recipes/java-settings.md) |  |

# Examples

### Tag based syntax

```cfml
<cfcomponent displayname="Hello" output="false" style="document" hint="hint for Hello">
    <!--- functions and other values here -->
</cfcomponent>
```

### Script based syntax

```cfml
component displayname="Script Widget" output="false" {
 // functions and properties here
}
```

### Serializing a CFC's properties to JSON

```cfml
myCfc = new component {
  property name="foo" type="string";
  property name="bar" type="numeric";
  foo = "hello";
  bar = 42;
};
dump(myCfc); // See CFC object with properties
jsonString = serializeJson(var=myCfc, compact=false);
writeOutput(jsonString); // Output: {"foo":"hello","bar":42}
```








# Categories

[Components (CFCs)](../../categories/component.md), [Core CFML Language](../../categories/core.md), [Static](../../categories/static.md)

# See Also

[getClass() Method for Components](../../recipes/component-getclass-method.md), [Convert a CFML Function/Component to use in Java](../../recipes/convert-a-cfml-func-to-java.md), [Dynamic Proxy Enhancements in Lucee 7](../../recipes/dynamic-proxy-enhancements.md), [RestInitApplication()](../functions/restinitapplication.md), [Inline Components](../../recipes/inline-components.md), [Java - Explicit Casting of a Component to a Specific Interface](../../recipes/java-explicit-casting.md), [JavaSettings in Application.cfc, Components and CFConfig.json](../../recipes/java-settings.md), [New Operator in Lucee](../../recipes/new-operator.md), [REST Services with Lucee](../../recipes/rest-services.md), [Sub Components](../../recipes/sub-components.md), [<cfargument>](argument.md), [<cffunction>](function.md), [<cfinterface>](interface.md), [<cfinvoke>](invoke.md), [<cfinvokeargument>](invokeargument.md), [<cfobject>](object.md), [<cfproperty>](property.md), [<cfstatic>](static.md)