# <cfcollection>

Allows you to create and administer Search collections.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfcollection
    engine=string
    categories=boolean
    action=create|repair|delete|optimize|list|map|categoryList
    collection=string
    path=string
    language=string
    name=string
    mode=hybrid|keyword|vector
    embedding=string
    ratio=numeric
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| engine | string | No | This attribute only exists for compatibility reasons to other CFML engines, the attribute is completely ignored by Lucee. |  |
| categories | boolean | No | Used only for creating a collection |  |
| action | string | No | Specifies the action to perform. | list |
| collection | string | No | Specifies a collection name or an alias if action = "map" |  |
| path | string | No | Absolute path to a Lucene collection. |  |
| language | string | No | language the collection is based on: possible values are: english, german, russian, dutch, french, italian, norwegian, portuguese, spanish, brazilian, chinese, greek, thai, danish, japanese, norwegian, korean |  |
| name | string | No | Name for the query results returned by the list action. *Alias: variable* |  |
| mode | string | No | Specifies the search algorithm to use when querying this collection. Options: - `keyword`: Traditional term-based search using Lucene (default) - `vector`: Pure semantic search using vector embeddings - `hybrid`: Combines keyword and vector search for optimal results, balancing term matching with semantic understanding When set to `keyword`, the `embedding` attribute is ignored. Vector and hybrid modes require an embedding service to be specified. |  |
| embedding | string | No | Specifies the embedding service to use for creating vector representations of documents, enabling semantic search capabilities. Valid options: - `TF-IDF`: Uses Term Frequency-Inverse Document Frequency statistical method for generating document vectors - `word2vec`: Uses pre-trained word vectors to create document embeddings with better semantic understanding - *class-name*: Name of a custom class implementing the `org.lucee.extension.search.lucene.embedding.EmbeddingService` interface *Alias: embeddingservice* |  |
| ratio | numeric | No | When `mode="hybrid"`, this value controls the balance between keyword and vector search components. Value range is 0.0 to 1.0, where: - 0.5: Equal weight given to both keyword and vector search (default) - Values greater than 0.5: Greater emphasis on vector search (semantic matching) - Values less than 0.5: Greater emphasis on keyword search (exact term matching) For example, a ratio of 0.7 would give 70% weight to vector search and 30% to keyword search. This attribute is ignored when mode is not "hybrid". |  |

# Examples

```cfml
<cfcollection action="Create" collection="colName" path= "path" language="">
<cfcollection action="Delete" collection="colName">

```








# Categories

[Search](../../categories/search.md)

# See Also

[Lucene 3 Extension](../../recipes/lucene-search.md), [<cfindex>](index.md), [<cfsearch>](search.md), [Lucee uses Apache Lucene for full text indexing](../../guides/Various/TIPS/TIPS-serach-engine.md)