# <cfcol>

Defines table column header, width, alignment, and text. Used only inside a cftable.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfcol
    header=string
    width=number
    align=string
    text=string
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| header | string | Yes | The text for the column's header. |  |
| width | number | No | The width of the column in characters (the default is 20). If the length of the data displayed exceeds the width value, the data is truncated to fit. |  |
| align | string | No | Column alignment, Left, Right, or Center. |  |
| text | string | No | Double-quote delimited text that determines what displays in the column. The rules for the text attribute are identical to the rules for cfoutput sections; it can consist of a combination of literal text, HTML tags, and query record set field references. You can embed hyperlinks, image references, and input controls in columns. |  |

# Examples

```cfml
<cfset data = queryNew("id,name,age", "integer,varchar,integer", [
    {id:1,name:"Item1",age:20},
    {id:2,name:"Item2",age:24},
    {id:3,name:"Item3",age:44},
    {id:4,name:"Item4",age:42}
])>
<cfquery name="qryData" dbtype="query">
    SELECT *
    FROM data
</cfquery>
<cftable query="qryData" startRow="1" colSpacing="3"  border=true  HTMLTable colHeaders>
    <cfcol header="<b>Id</b>" align="Left" width="15" text="#id#">
    <cfcol header="<b>Name</b>" align="Left" width="15" text="#name#">
    <cfcol header="<b>Age</b>" align="Left" width="15" text="#age#">
</cftable>
```






