# <cfchartseries>

Used with the [<cfchart>](chart.md) and [<cfchartdata>](chartdata.md) tags. This tag defines a series.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [Chart Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#D46B46A9-A0E3-44E1-D972A04AC3A8DC10)

```
<cfchartseries
    colorlist=string
    itemColumn=string
    markerStyle=string
    paintStyle=string
    query=any
    seriesColor=string
    seriesLabel=string
    type=string
    valueColumn=string
    dataLabelStyle=string
><!--- body ---></cfchartseries>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| colorlist | string | No | Applies if chartseries type attribute = "pie". Sets pie slice colors. Comma-delimited list of hex values or supported, named web colors; see name list in the [<cfchart>](chart.md) Usage section. For a hex value, use the form "##xxxxxx", where x = 0-9 or A-F; use two pound signs or none. |  |
| itemColumn | string | No | Name of a column in the query specified in the query attribute; contains the item label for a data point to graph. |  |
| markerStyle | string | No | Applies to chartseries type attribute values line, curve and scatter, and show3D attribute value no. |  |
| paintStyle | string | No | Sets the paint display style of the data series. |  |
| query | any | No | Name of CFML query from which to get data. |  |
| seriesColor | string | No | Color of the main element (such as the bars) of a chart. For a pie chart, the color of the first slice. Hex value or supported named color; see name list in the [<cfchart>](chart.md) Usage section. For a hex value, use the form "##xxxxxx", where x = 0-9 or A-F; use two pound signs or none. |  |
| seriesLabel | string | No | Text of data series label |  |
| type | string | Yes | Sets the chart display style |  |
| valueColumn | string | No | Name of a column in the query specified in the query attribute; contains data values to graph. |  |
| dataLabelStyle | string | No | Specifies the way in which the color is applied to the item in the series: - None = nothing is printed (default) - Value = the value of the datapoint - Rowlabel = the row's label - Columnlabel = the column's label - Pattern |  |

# Examples

### Chartseries Example

```cfml
<cfchart format="jpg" title="Sales Result" backgroundcolor="magenta" showborder="true">
  <cfchartseries type="bar" paintstyle="light">
    <cfchartdata item="2016" value="100">
    <cfchartdata item="2017" value="300">
    <cfchartdata item="2018" value="500">
    <cfchartdata item="2019" value="700">
  </cfchartseries>
</cfchart>
```








# See Also

[<cfchart>](chart.md), [<cfchartdata>](chartdata.md)