# <cfchartdata>

Used with the [<cfchart>](chart.md) and [<cfchartseries>](chartseries.md) tags. This tag defines chart data points.

It's data is submitted to the [<cfchartseries>](chartseries.md) tag.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [Chart Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#D46B46A9-A0E3-44E1-D972A04AC3A8DC10)

```
<cfchartdata
    item=string
    value=number
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| item | string | Yes | string; data point name |  |
| value | number | Yes | number or expression; data point value |  |

# Examples

### Simple example for Chartdata

```cfml
<cfchart format="jpg" title="Sales Result" backgroundcolor="yellow" showborder="true">
  <cfchartseries type="curve">
    <cfchartdata item="2016" value="#RandRange(100,500)#">
    <cfchartdata item="2017" value="#RandRange(100,500)#">
    <cfchartdata item="2018" value="#RandRange(100,500)#">
    <cfchartdata item="2019" value="#RandRange(100,500)#">
  </cfchartseries>
</cfchart>
```








# See Also

[<cfchart>](chart.md), [<cfchartseries>](chartseries.md)