# <cfchart>

Generates and displays a chart.

<https://github.com/lucee/extension-chart>

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

**Requires Extension:** [Chart Extension for Jakarta EE (Lucee 7+)](https://download.lucee.org/#D46B46A9-A0E3-44E1-D972A04AC3A8DC10)

```
<cfchart
    backgroundColor=string
    chartHeight=number
    chartWidth=number
    dataBackgroundColor=string
    font=string
    fontBold=boolean
    fontItalic=boolean
    fontSize=number
    foregroundColor=string
    format=string
    gridlines=number
    labelFormat=string
    categoryLabelPositions=string
    markerSize=number
    name=string
    pieSliceStyle=string
    scaleFrom=number
    scaleTo=number
    seriesPlacement=string
    show3D=boolean
    showBorder=any
    showLegend=boolean
    showMarkers=boolean
    showXGridlines=boolean
    showXLabel=boolean
    showTooltip=boolean
    source=string
    showYGridlines=boolean
    sortXAxis=boolean
    style=string
    title=string
    tipbgcolor=string
    tipStyle=string
    url=string
    xAxisTitle=string
    xAxisType=string
    xOffset=number
    yAxisTitle=string
    yAxisType=string
    yOffset=number
    base64=boolean
><!--- body ---></cfchart>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| backgroundColor | string | No | Color of the area between the data background and the chart border, around labels and around the legend. Hexadecimal value or supported named color. For a hex value, use the form: textColor = "##xxxxxx", where x = 0-9 or A-F; use two hash signs or none. |  |
| chartHeight | number | No | Chart height; integer number of pixels |  |
| chartWidth | number | No | Chart width; integer number of pixels |  |
| dataBackgroundColor | string | No | color for control. For a hex value, use the form: textColor = "##xxxxxx", where x = 0-9 or A-F; use two hash signs or none. |  |
| font | string | No | Font of data in column. |  |
| fontBold | boolean | No | Yes: displays grid control text in bold |  |
| fontItalic | boolean | No | Yes: displays grid control text in italics |  |
| fontSize | number | No | Size of text in column. |  |
| foregroundColor | string | No | color for control. For a hex value, use the form: textColor = "##xxxxxx", where x = 0-9 or A-F; use two hash signs or none. |  |
| format | string | No | File format in which to save graph. - gif - jpg - png |  |
| labelFormat | string | No | Format for Y-axis labels. |  |
| categoryLabelPositions | string | No | Label position relative to axis: standard, up_45, up_90, down_45, down_90 or horizontal (standard) and vertical (down_90). Default is horizontal. |  |
| markerSize | number | No | Size of data point marker in pixels. Integer. |  |
| name | string | No | Page variable name. String. Generates the graph as binary data and assigns it to the specified variable. Suppresses chart display. You can use the name value in the cffile tag to write the chart to a file. |  |
| pieSliceStyle | string | No | Applies to chartseries type attribute value pie. |  |
| scaleFrom | number | No | Y-axis minimum value; integer |  |
| scaleTo | number | No | Y-axis max value; integer |  |
| show3D | boolean | No | Display chart with three-dimensional appearance. |  |
| showBorder | any | No | Whether to display a border around the chart |  |
| showLegend | boolean | No | yes: if chart contains more than one data series, display legend |  |
| showMarkers | boolean | No | Applies to chartseries type attribute values line, curve and scatter. yes: display markers at data points |  |
| showXGridlines | boolean | No | yes: display X-axis gridlines |  |
| showXLabel | boolean | No | yes: shows the x-axis labels |  |
| showTooltip | boolean | No | show the tooltip or not |  |
| source | string | No | variable name of the source path, if set the path to the source file is returned and no image tag is written to response stream. |  |
| showYGridlines | boolean | No | yes: display Y-axis gridlines |  |
| sortXAxis | boolean | No | Display column labels in alphabetic order along X-axis. Ignored if the xAxisType attribute is scale. |  |
| title | string | No | Title of the chart. |  |
| url | string | No | URL to open if the user clicks item in a data series; the onClick destination page. The following variables will be substituted [ $SERIESLABEL$, $ITEMLABEL$, $VALUE$ ] If the url does not contain a `?` the following is appended `?series=$SERIESLABEL$&category=$ITEMLABEL$&value=$VALUE$` Otherwise, you will need to specify the query string manually If the url starts with `javascript:` only variable substitution is done (since 1.20.1) |  |
| xAxisTitle | string | No | text; X-axis title |  |
| xOffset | number | No | Applies if show3D="yes". Number of units by which to display the chart as angled, horizontally |  |
| yAxisTitle | string | No | text; X-axis title |  |
| yOffset | number | No | Applies if show3D="yes". Number of units by which to display the chart as angled, horizontally. |  |
| base64 | boolean | No | Render chart inline using a base64 data url. |  |

# Examples

### Example for cfchart

```cfml
<cfchart format="jpg" title="Sales Report" backgroundcolor="cyan" showborder="true">
  <cfchartseries type="pie">
    <cfchartdata item="2012" value="2000">
    <cfchartdata item="2013" value="4000">
    <cfchartdata item="2014" value="5000">
    <cfchartdata item="2015" value="7000">
  </cfchartseries>
</cfchart>
```








# See Also

[<cfchartdata>](chartdata.md), [<cfchartseries>](chartseries.md)