# <cfcatch>

Used only inside a [<cftry>](try.md), the cfcatch tag catches and process exceptions.

By specifying the type of error with the type attribute, different types of exceptions can be handled differently.

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfcatch
    name=string
    type=string
><!--- body ---></cfcatch>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | No | The name for the struct containing the exception information by default it is cfcatch (in Lucee, the cfcatch variable will also be populated) *Alias: variable* |  |
| type | string | No | Type of catch, default:Any |  |

# Examples

### Simple example with cfcatch

```cfml
<cftry>
  <cfset a = 3/0>
  <cfdump var="#c#" />
  <cfcatch>
    <cfdump var="#cfcatch#">
  </cfcatch>
</cftry>
```

### Nice trick with echo and cfcatch

```cfml
try {
    throw "demo echo trick";
} catch ( e ){
    echo( e ); // outputs the error nicely using the error template
    echo( cfcatch ); // lucee always populates cfcatch
}
```








# Categories

[Core CFML Language](../../categories/core.md)

# See Also

[Exception Output](../../recipes/exception-output.md), [Retry](../../recipes/retry.md), [<cffinally>](finally.md), [<cfrethrow>](rethrow.md), [<cfretry>](retry.md), [<cfthrow>](throw.md), [<cftry>](try.md)