# <cfcase>

Handle one case of a [<cfswitch>](switch.md)

This tag **must** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfcase
    value=string
    delimiters=string
><!--- body ---></cfcase>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| value | string | Yes | One or more constant values that cfswitch compares to the specified expression case-insensitive comparison. If a value matches the expression, cfswitch executes the code between the cfcase start and end tags. Separate multiple values with a comma or other delimiter, as specified in the delimiters parameter. Duplicate value attributes are not allowed and causes a runtime error. |  |
| delimiters | string | No | Specifies the character that separates multiple entries in a list of values. You can specify multiple delimiter characters and you can use any of them to separate the values to be matched. Delimiters can only be used in the tag syntax. Default delimiter: , Note: in [<cfscript>](script.md), delimitered values are not supported for case statements. Use an individual case statement for each value. |  |

# Examples

### Tag syntax

```cfml
<cfset expr = 2>
<cfswitch expression="#expr#">
    <cfcase value=1>
        this is from case 1
    </cfcase>
    <cfcase value=2$3$4 delimiters="$">
        this is from case 2
    </cfcase>
    <cfcase value=5,6,7>
        this is from case 3
    </cfcase>
    <cfdefaultcase>
        this is from default part
    </cfdefaultcase>
</cfswitch>
```

### Script syntax

```cfml
  expr = 1;
    switch(expr){
        case 1:
            result = 1;
            break;
        case 2:
        case 3:
            result = "2 or 3";
            break;
        case 0:
            result = 0;
            break;
        default:
            result = "defaultCase";
    }
    dump( result );
```








# See Also

[<cfdefaultcase>](defaultcase.md), [<cfswitch>](switch.md)