# <cfcache>

Speeds up page rendering when dynamic content does not have to be retrieved each time a user accesses a page.

To accomplish this, cfcache creates temporary files that contain the static HTML returned from a page.

You can use cfcache for simple URLs and URLs that contain URL parameters.

This tag **may** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfcache
    action=cache|flush|clientCache|serverCache|optimal|content|put|get
    key=string
    id=any
    throwOnError=boolean
    name=string
    metadata=string
    value=any
    cacheName=string
    username=string
    password=string
    protocol=string
    timeSpan=timespan
    idleTime=timespan
    directory=string
    cacheDirectory=string
    timeout=any
    expireURL=string
    port=number
    useQueryString=boolean
    useCache=boolean
    stripWhiteSpace=boolean
    dependsOn=string
><!--- body ---></cfcache>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| action | string | No | - cache (default): server-side and client-side template caching. - flush: refresh cached pages (template caching). - clientcache: browser-side caching only. To cache a personalized page, use this option. - servercache: server-side caching only. Not recommended. - optimal: same as "cache". - content: same as cache, but cache only the body of the tag, not the complete template (template caching). - put: adds a key value pair to object cache (see function cachePut for more details) - get: gets value matching given key from object cache (see function cacheGet for more details) | cache |
| key | string | No | key to access cache |  |
| id | any | No | Id of the cached object |  |
| throwOnError | boolean | No | A Boolean value specifying whether t throw an error if the flush action encounters an error. Otherwise the action does not generate an error if it fails. If this attribute is true you can handle the error in a cfcatch block, for example, if a specified id value is invalid |  |
| name | string | No | name of return variable, valid with action="get" |  |
| metadata | string | No | Name of the struct variable |  |
| value | any | No | For action="set", object which needs to be stored |  |
| cacheName | string | No | definition of the cache used by name, when not set the "default Object Cache" defined in Lucee Administrator is used instead. |  |
| protocol | string | No | Specifies the protocol used to create pages from cache. Either http:// or https://. The default is http://. |  |
| timeSpan | timespan | No | The interval until the item is flushed from the cache. A decimal number of days, for example: - .25, for one-fourth day (6 hours) - 1, for one day - 1.5, for one and one half days A return value from the CreateTimeSpan function, for example, "#CreateTimeSpan(0,6,0,0)#". The default action is to flush the item when it is idle for the time specified by the idleTime attribute, or cfcache action="flush" executes. |  |
| idleTime | timespan | No | Flushes the cached item if it is not accessed for the specified time span: A decimal number of days, for example: - .25, for one-fourth day (6 hours) - 1, for one day - 1.5, for one and one half days A return value from the CreateTimeSpan function, for example, "#CreateTimeSpan(0,6,0,0)#". |  |
| directory | string | No | Absolute path of cache directory. |  |
| cacheDirectory | string | No | Absolute path of cache directory (alias for directory). |  |
| expireURL | string | No | A URL reference. Can include wildcards, for example: "*/view.cfm?id=*". Lucee flushes, from the cache, pages that match the specified URL or pattern. |  |
| port | number | No | Port number of the web server from which the URL for the cached page is requested. In the internal call from cfcache to cfhttp, Lucee resolves each URL variable in the page; this ensures that links in the page remain functional. |  |
| useQueryString | boolean | No | Whether to consider the query_string when caching, default is `FALSE` with Lucee 7, before this was added, it was always effectively `TRUE` |  |
| useCache | boolean | No | Whether to use the cache, default is `TRUE`. When `FALSE` the cache ignored and still updated. |  |
| stripWhiteSpace | boolean | No | Whether to strip stripWhiteSpace, default is `FALSE`. currently only trims |  |

# Examples

### Cache Example

```cfml
<cfcache action='cache' timespan='#createTimeSpan( 0, 0, 0, 5 )#' idletime='#createTimeSpan( 0, 12, 0, 0 )#'>
  <cfdump var="#now()#" />
</cfcache>
```








# Categories

[Cache](../../categories/cache.md)