# <cfbreak>

Used to break out of a [<cfloop>](loop.md) or  [<cfwhile>](while.md)

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfbreak #string label#>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| label | string | No | used to address a specific loop instead of the nearest one. |  |

# Examples

```cfml
// breaking out using a label
x = 0;
WhileLabel: while (x < 10){
    writeOutput("x is #x#<br>");
    switch (x){
        case 1:
            break;
        case 3:
            break WhileLabel;
    }
    x++;
    writeOutput("end of loop<br>");
}
writeOutput("After loop, x is #x#<br>");
```








# See Also

[<cfloop>](loop.md), [<cfwhile>](while.md)