# <cfargument>

Defines a parameter that may be sent when the function is called.

When used, cfargument tag(s) must be the first tags used within the cffunction.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfargument
    name=string
    type=string
    required=boolean
    default=any
    displayName=string
    hint=string
    passBy=reference|value
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | Yes | The name of the argument |  |
| type | string | No | The type of the argument - any - array - binary - boolean - date, datetime, time, timestamp - function - guid - image - locale - numeric, number - query - queryColumn - object - string - struct - timezone - timespan - uuid - variableName, variable_name - variablestring, variable_string - xml - component - componentName |  |
| required | boolean | No | is argument required or not |  |
| default | any | No | default value of the argument |  |
| displayName | string | No | name to display (only used by components) |  |
| hint | string | No | hint to the argument (only used by components) |  |
| passBy | string | No | should the argument passed as reference (default) or as a value | reference |

# Examples

```cfml
<cfoutput>
 	<cffunction access="private" name="add">
		<cfargument name="arg1" type="Numeric" required />
		<cfargument name="arg2" type="Numeric" required />
	 	<cfreturn arg1 + arg2 />
	</cffunction>
	<cfdump var="Define function Using tag.It returns :#add(4,2)#" />
</cfoutput>
```

```cfml
		writeDump("Define function using cfscript. It returns: "&add(2,3));
		public function add(required numeric arg1,required numeric arg2){
			return arg1+arg2;
		}
```





## Related System Properties / Environment Variables

- [LUCEE_SUPPRESS_WS_BEFORE_ARG](../../recipes/environment-variables-system-properties.md#lucee_suppress_ws_before_arg) - A boolean value. If enabled, Lucee suppresses whitespace defined between the cffunction starting tag and the last cfargument tag. This setting is ignored when there is different output between these tags as whitespace
  ***Type:** boolean, **Default:** true*



# Categories

[Components (CFCs)](../../categories/component.md)

# See Also

[<cfcomponent>](component.md), [<cffunction>](function.md)