# Application.cfc / <cfapplication>

Defines a CFML Application and configures the properties / behavior of that Application:

- name
- datasources
- timeouts
- client variable settings
- session settings
- cookies
- and more!

By default, client variables are disabled, and Session and Application variables are stored in memory.

All these settings below can also be configured using the Modern `Application.cfc` approach, see [Application.cfc guide](../../recipes/application-cfc.md).

These properties can be configured in the `Application.cfc` constructor

i.e.

```
this.name = "myApplication";
this.ormsettings.autogenmap = false;

// you can also configure your own custom tag attributes defaults, see [[tags]]
// i.e. this overrides the default log file of "application.log"
// instead this application will write out all default logs to a log file
// named after the Application ( i.e. 'myApplication.log')

this.tag.log.log = this.name & ".log";
```

To verify your current runtime Application configuration use [GetApplicationSettings()](../functions/getapplicationsettings.md)

The runtime configuation takes the base server `.CFConfig.json` / admin configuration, overridden by these Application settings.

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfapplication
    name=string
    datasource=object
    defaultDatasource=object
    datasources=struct
    logs=struct
    mailservers=array
    caches=struct
    action=create|update
    loginStorage=session
    clientManagement=boolean
    clientStorage=string
    sessionType=cfml|j2ee
    sessionStorage=string
    clientCluster=boolean
    sessionCluster=boolean
    setClientCookies=boolean
    cgiReadonly=boolean
    bufferOutput=boolean
    sessionManagement=boolean
    sessionTimeout=timespan
    clientTimeout=timespan
    applicationTimeout=timespan
    requestTimeout=timespan
    setDomainCookies=boolean
    scriptProtect=string
    proxy=struct
    mappings=struct
    functionPaths=any
    customTagPaths=any
    componentPaths=any
    secureJson=boolean
    wstype=string
    typeChecking=boolean
    compression=boolean
    suppressRemoteComponentContent=boolean
    secureJsonPrefix=string
    localMode=string
    mailListener=any
    queryListener=any
    SerializationSettings=struct
    tag=struct
    ormEnabled=boolean
    ormSettings=struct
    s3=struct
    ftp=struct
    triggerDataMember=boolean
    InvokeImplicitAccessor=boolean
    cacheObject=string
    cacheFunction=string
    cacheQuery=string
    cacheTemplate=string
    cacheResource=string
    cacheInclude=string
    cacheHTTP=string
    cacheFile=string
    cacheWebservice=string
    onMissingTemplate=object
    locale=locale
    timeZone=timezone
    webCharset=String
    resourceCharset=String
    scopeCascading=String
    searchImplicitScopes=boolean
    searchResults=boolean
    authCookie=struct
    sessionCookie=struct
    enableNULLSupport=boolean
    nullSupport=boolean
    preciseMath=boolean
    psq=boolean
    variableUsage=string
    cachedAfter=timespan
    blockedExtForFileUpload=string
    javaSettings=struct
    xmlFeatures=struct
    regex=any
    sameFormFieldsAsArray=boolean
    sameURLFieldsAsArray=boolean
    showdoc=boolean
    showmetric=boolean
    showdebug=boolean
    debuggingDatabase=boolean
    debuggingException=boolean
    debuggingDump=boolean
    debuggingTracing=boolean
    debuggingTimer=boolean
    debuggingImplicitAccess=boolean
    debuggingQueryUsage=boolean
    debuggingThread=boolean
    debuggingTemplate=boolean
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| name | string | No | The name of your application. This name can be up to 64 characters long. Required for application and session variables, optional for client variables. By using a different name, i.e. based off cgi.http_host, you can run multiple, separate instances of an application using the same directory / code base. |  |
| datasource | object | No | alias for default datasource |  |
| defaultDatasource | object | No | the default datasource for this environment |  |
| datasources | struct | No | A structure that contains datasources definitions. |  |
| logs | struct | No | A structure that contains one or more log definitions. ``` { "classic": { "appender":"resource", "appenderArguments": { "path" :"{lucee-config}/logs/classic.log" }, "layout":"classic", "level":"info" }, "pattern": { "appender": "resource", "appenderArguments": { "path": "{lucee-config}/logs/pattern.log" }, "level": "info", "layout": "pattern", "layoutArguments": { "pattern": "%d{yyyy-MM-dd HH:mm:ss,SSS} [%t] %-5p %c - %m%n" } } } ``` *Alias: log* |  |
| mailservers | array | No | Array of structs that defines the mailserver configuration. Each struct configures one mailserver. Struct keys used for smtp configuration are: - **host (string):** host name of smtp server (you can use `host` or `server` as the key; `smtp` is also supported since Lucee **Lucee 6.2.2.50-SNAPSHOT**) - **port (numeric):** port number of smtp server - **username (string):** smtp username - **password (string):** smtp userpassword - **ssl (boolean):** enable secure connections via SSL. - **tls (boolean):** enables Transport Layer Security. - **lifeTimespan (timespan):** overall timeout for the connections established to the mail server. - **idleTimespan (timespan):** idle timeout for the connections established to the mail server. ```cfc // Example configuration in Application.cfc this.mailservers = [ { // You can use any of these keys for the host: 'host', 'server', or 'smtp' host: 'smtp.some-email-domain.com', // server: 'smtp.some-email-domain.com', // smtp: 'smtp.some-email-domain.com', // since Lucee 6.2.2.50-SNAPSHOT port: 587, username: 'mymailaccount@some-email-domain.com', password: 'encrypted:8f7eb9...342', ssl: false, tls: true, lifeTimespan: createTimeSpan(0,0,1,0), idleTimespan: createTimeSpan(0,0,0,10) } ]; ``` *Alias: mail, mails* |  |
| caches | struct | No | A structure that contains cache definitions. *Alias: cache* |  |
| action | string | No | The action to perform on the CFML application for the current request - **create:** creates a new CFML application context and overwrites any existing application - **update:** updates the existing CFML application context if one exists, otherwise creates a new one The default value is: create. | create |
| loginStorage | string | No | storage for the login data: - **session:** store login information in the Session scope - **cookie:** store login information in the Cookie scope (removed in Lucee 7.0) |  |
| clientManagement | boolean | No | Yes or No. Enables client variables. Default is No. |  |
| clientStorage | string | No | Specifies how Lucee stores client variables: - **memory:** the session is only kept in memory - **cookie:** the session is stored in the client cookie - **file (default):** the session is stored in a local file - **"datasource-name"\|"cache-name":** when you select a name of an available datasource or cache, the client scope will be stored in there |  |
| sessionType | string | No | Lucee provide 2 kind of sessions: - **cfml:** session handled by Lucee - **j2ee:** session handled by the Servlet Engine used Default value is defined in the Lucee Web Administrator. "j2ee" can not use a session storage. |  |
| sessionStorage | string | No | Specifies how Lucee stores session variables: - **memory (default):** the session is only kept in memory - **cookie:** the session is stored in the client cookie - **file:** the session is stored in a local file - **"datasource-name"\|"cache-name":** when you select a name of an available datasource or cache, the session scope will be stored in there |  |
| clientCluster | boolean | No | If set to true, lucee uses the storage backend for the client scope as master and Lucee checks for changes in the storage backend with every request. If set to false (default), the storage is only used as slave, lucee only initially gets the data from the storage. Ignored for storage type "memory". |  |
| sessionCluster | boolean | No | if set to true, lucee uses the storage backend for the session scope as master and Lucee checks for changes in the storage backend with every request. If set to false (default), the storage is only used as slave, lucee only initially gets the data from the storage. Ignored for storage type "memory". |  |
| setClientCookies | boolean | No | Yes or No. Yes enables client cookies. Default is Yes. If you set this attribute to"No", Lucee does not automatically send the CFID and CFTOKEN cookies to the client browser; you must manually code CFID and CFTOKEN on the URL for every page that uses Session or Client variables. |  |
| cgiReadonly | boolean | No | if set to true, the CGI Scope is readonly. | true |
| bufferOutput | boolean | No | if set to true (default) the output written to the body of the tag is buffered and in case of an exception also outputted. if set to false the content to body is ignored and not disabled when a failure in the body of the tag occur. |  |
| sessionManagement | boolean | No | Yes or No. Yes enables session variables. Default is No. |  |
| sessionTimeout | timespan | No | Enter the CreateTimeSpan function and values in days, hours, minutes, and seconds, separated by commas, to specify the lifespan of session variables. The default value is specified in the Variables page of the Lucee Administrator. |  |
| clientTimeout | timespan | No | Enter the CreateTimeSpan function and values in days, hours, minutes, and seconds, separated by commas, to specify the lifespan of client variables. The default value is specified in the Variables page of the Lucee Administrator. |  |
| applicationTimeout | timespan | No | Sets the lifespan of variables that live in the application scope. Accepts a TimeSpan created using the `createTimeSpan()` function. The default value is defined on the Variables page of the Lucee Administrator. |  |
| requestTimeout | timespan | No | Sets the amount of time Lucee will wait for a request to finish before a request timeout will be raised. This means that the execution of the request will be stopped. *Alias: timeout* |  |
| setDomainCookies | boolean | No | Yes or No. Sets the CFID and CFTOKEN cookies for a domain, not just a single host. Applications that are running on clusters must set this value to Yes. The default is No. |  |
| scriptProtect | string | No | Specifies whether to protect variables from cross-site scripting attacks. You may specify the string value also as a comma separated list to fine tune protection. - **none:** disables cross-site scripting protection - **all (default):** applies cross-site scripting protection to cgi, url, form and cookie scope variables - **cgi:** applies protection to cgi scope variables only - **url:** applies protection to url scope variables only - **form:** applies protection to form scope variables only - **cookie:** applies protection to cookie scope variables only |  |
| proxy | struct | No | general proxy that should be used for all connections with the following format: {server:"localhost", port:12345, username:"susi", password: "sorglos"} |  |
| mappings | struct | No | A structure that contains mappings. Each element in the structure consists of a key and a value. The logical path is the key and the absolute path is the value. [Define a mapping](../../recipes/mappings-how-to-define-a-reg-mapping.md) |  |
| functionPaths | any | No | Array or String list of paths where you have your functions. |  |
| customTagPaths | any | No | Contains custom tag paths. |  |
| componentPaths | any | No | Contains component paths. |  |
| secureJson | boolean | No | A Boolean value that specifies whether to add a security prefix in front of the value that a function returns in JSON-format in response to a remote call. |  |
| wstype | string | No | webservice type used, only the following is supported - **Axis1 (default):** The Apache Axis 1 implementation is used |  |
| typeChecking | boolean | No | If disabled, Lucee ignores type definitions with function arguments and return values | true |
| compression | boolean | No | Enable compression (GZip) for the Lucee Response stream for text-based responses when supported by the client (Web Browser). |  |
| suppressRemoteComponentContent | boolean | No | Suppress content written to response stream when a Component is invoked remotely. Only works if the content was not flushed before. |  |
| secureJsonPrefix | string | No | The security prefix to put in front of the value that a function returns in JSON-format in response to a remote call if the secureJSON setting is true. |  |
| localMode | string | No | Defines how the local scope of a function is invoked when a variable with no scope definition is used (default value set in the lucee administrator). - **modern:** (alias true) new unscoped variables will be set to the Local Scope - **classic (CFML standard):** (alias false) new unscoped variables will be set to the Variables Scope |  |
| mailListener | any | No | Defines a mail listeners for cfmail See the [Mail Listeners](../../recipes/mail-listener.md) for details |  |
| queryListener | any | No | Defines a query listeners for cfquery. See the [Query Listeners](../../recipes/query-listener.md) for details |  |
| SerializationSettings | struct | No | ``` { preserveCaseForStructKey: boolean, preserveCaseForQueryColumn: boolean, serializeQueryAs: "column\|struct\|row" } ``` *Alias: serialization* |  |
| tag | struct | No | tags/attributes default value in the following structure: {location:{addtoken=false}} |  |
| ormEnabled | boolean | No | Specifies whether ORM should be enabled for the current application context. The default is false. |  |
| ormSettings | struct | No | A struct that defines all the ORM settings, the following keys are supported: - **autogenmap(default:true; autogenmap=false is not supported yet):** Specifies whether Lucee should automatically generate mapping for the persistent CFCs. If autogenmap=false, mapping should be provided in the form of "{cfc-name}.cfc.hbm.xml" files. - **automanageSession(default:true; not supported yet):** Lets you specify if Lucee must manage Hibernate session automatically. If enabled: Lucee manages the session completely. That is, it decides when to flush the session, when to clear the session, and when to close the session. If disabled: The application is responsible for managing flushing, clearing, or closing of the session. The only exception is (in the case of transaction), when the transaction commits, the application flushes the session. Lucee closes the ORM session at the end of request irrespective of this flag being enabled or disabled. - **cacheconfig:** Specifies the location of the configuration file that should be used by the secondary cache provider.This setting is used only when secondarycacheenabled=true. - **cacheprovider:** Specifies the cache provider that should be used by ORM as secondary cache. - **catalog:** Specifies the default Catalog that should be used by ORM. - **cfclocation:** Specifies the directory (or array of directories) that should be used by Lucee to search for persistent CFCs to generate the mapping. If cfclocation is set, Lucee looks at only the paths specified in it. If it is not set, Lucee looks at the application directory, its sub-directories, and its mapped directories to search for persistent CFCs. - **datasource:** Specifies the data source that should be used by ORM. If it is not specified here, then the data source specified for the application is picked up. - **dbcreate(default:none):** Hibernate can automatically create the tables for your application in the database. dbCreate takes the following **values:** - **update:** Setting this value creates the table if it does not exist or update the table if it exists. - **dropcreate:** Setting this value drops the table if it exists and then creates it. - **none:** Setting this value does not change anything in the database schema. - **dialect:** Specifies the dialect.Lucee supports the following dialects: [Cache 2007.1, Cache71, Cache 2007.1, DB2, DB2/390, DB2/400, DB2390, DB2400, DB2AS400, DB2OS390, DataDirectOracle9, Derby, Firebird, FrontBase, H2, H2DB, HSQL, HSQLDB, Informix, Ingres, Interbase, JDataStore, MSSQL, Mckoi, MckoiSQL, MicrosoftSQLServer, Mimer, MimerSQL, MySQL, MySQL/InnoDB, MySQL/MyISAM, MySQL5, MySQL5/InnoDB, MySQL5InnoDB, MySQLInnoDB, MySQLMyISAM, MySQLwithInnoDB, MySQLwithMyISAM, Oracle, Oracle10g, Oracle8i, Oracle9, Oracle9i, Pointbase, PostgreSQL, PostgresPlus, Progress, SAPDB, SQLServer, Sybase, Sybase11, SybaseASE15, SybaseAnywhere, com.ddtek.jdbc.db2.DB2Driver, com.microsoft.jdbc.sqlserver.SQLServerDriver, oracle.jdbc.driver.OracleDriver, org.firebirdsql.jdbc.FBDriver, org.gjt.mm.mysql.Driver, org.h2.Driver, org.hsqldb.jdbcDriver, org.postgresql.Driver] - **eventHandling(default:false):** Specifies whether ORM Event callbacks should be given. - **flushatrequestend(default:true):** Specifies whether ormflush should be called automatically at request end. If flushatrequestend is false, ormflush is not called automatically at request end. - **logSQL(default:false):** Specifies whether the SQL queries that are executed by ORM will be logged. If LogSQL=true, the SQL queries are logged to the console. - **ormconfig:** The Hibernate configuration file. This file contains various configuration parameters like, dialect, cache settings, and mapping files that are required for the application. For more details, see <http://www.hibernate.org/hib_docs/reference/en/html/session-configuration.html>. The settings defined in the ormsettings override the settings defined in the Hibernate Configuration XML file.The connection information in the Hibernate Configuration XML file is however ignored because Lucee uses its own connection pool. You will need to use this only when you need to use a hibernate setting that is not available using ormsetting. - **savemapping(default:false):** Specifies whether the generated Hibernate mapping file has to be saved to disc. If you set the value to true, the Hibernate mapping XML file is saved with the filename "CFC name".hbm.xml in the same directory as the CFC. If any value of savemapping is specified in CFC, it will override the value specified in the ormsetting. - **schema:** Specifies the default Schema that should be used by ORM. - **secondarycacheenabled(default:false):** Specifies whether secondary caching should be enabled - **skipCFCWithError(default:false;not implemented yet):** Lets you specify if Lucee must skip the CFCs that have errors. If set to true, Lucee ignores the CFCs that have errors. - **sqlscript:** Path to the SQL script file that gets executed after ORM is initialized. This applies if dbcreate is set to dropcreate. This must be the absolute file path or the path relative to the application.The SQL script file lets you populate the tables before the application is accessed. - **useDBForMapping(default:true):** Specifies whether the database has to be inspected to identify the missing information required to generate the Hibernate mapping. The database is inspected to get the column data type, primary key and foreign key information. |  |
| s3 | struct | No | A struct that defines default S3 settings, this settings can be overwritten as part of the S3 file path, the following keys are supported: - **accessKeyId:** S3 access key id - **awsSecretKey:** AWS (Amazon Web Service) Secret Key - **defaultLocation(default:us):** region for the bucket, possible values are [eu,us,us-west] - **host(default:"s3.amazonaws.com"):** hostname of the service |  |
| ftp | struct | No | A struct that defines default ftp settings, this settings can be overwritten as part of the ftp file path, the following keys are supported: - **username:** username to access the ftp server - **password:** password to access the ftp server - **port:** port of the FTP server - **host**: hostname of the FTP server (lucee.org) |  |
| triggerDataMember | boolean | No | If there is no accessible data member (property, element of the this scope) inside a component, Lucee searches for available matching &quot;getters&quot; or &quot;setters&quot; for the requested property. The following example should clarify this behaviour. &quot;somevar = myComponent.propertyName&quot;. If &quot;myComponent&quot; has no accessible data member named &quot;propertyName&quot;, Lucee searches for a function member (method) named &quot;getPropertyName&quot;. |  |
| InvokeImplicitAccessor | boolean | No | An alias for `triggerDataMember` |  |
| cacheObject | string | No | name of the cache used for object caching in this context |  |
| cacheFunction | string | No | name of the cache used for function caching in this context |  |
| cacheQuery | string | No | name of the cache used for query caching in this context |  |
| cacheTemplate | string | No | name of the cache used for template caching in this context |  |
| cacheResource | string | No | name of the cache used to store data from ram resource in this context |  |
| cacheInclude | string | No | name of the cache used to store data from an include |  |
| cacheHTTP | string | No | name of the cache used to store data from a http tag |  |
| cacheFile | string | No | name of the cache used to store data from file operations |  |
| cacheWebservice | string | No | name of the cache used to store data from webservice calls |  |
| onMissingTemplate | object | No | closure/udf executed when the requested template does not exist |  |
| locale | locale | No | Sets the country/language locale for CFML processing. The locale value determines the default format of date, time, number, and currency values, according to language and regional conventions. |  |
| timeZone | timezone | No | change the timezone definition for the current application context. |  |
| webCharset | String | No | character set used for output streams, form-, url-, and cgi scope variables and reading/writing the header |  |
| resourceCharset | String | No | character set used for reading from/writing to various resources |  |
| scopeCascading | String | No | Depending on this setting Lucee scans certain scopes to find a variable called from the CFML source. This will only happen, when the variable is called without a scope. (Example: #myVar# instead of #variables.myVar#), the following values are supported: - **strict:** scans only the variables scope - **small:** scans the scopes variables,url,form - **standard:** scans the scopes variables,cgi,url,form,cookie |  |
| searchImplicitScopes | boolean | No | alias to the attribute "scopecascading", takes a boolean value where true is equal to "standard" and false is equal to "strict" scope cascading mode. For details see the description for the attribute "scopecascading". |  |
| searchResults | boolean | No | When a variable has no scope defined (Example: #myVar# instead of #variables.myVar#), Lucee will also search available resultsets if this is set to true. *Alias: searchqueries, searchquery, searchresult* |  |
| authCookie | struct | No | cfauthorization cookie behaviour |  |
| sessionCookie | struct | No | A struct which defines session cookie behaviour; the following keys are supported: - **httpOnly (boolean):** Specifies if the session cookies (CFID/CFTOKEN) should have the HTTPOnly cookie flag set. This prevents the cookie value from being read from JavaScript. - **secure (boolean):** Specifies if the session cookies (CFID/CFTOKEN) should have the secure cookie flag set. When true the cookies are only sent over a secure transport (eg HTTPS). - **domain (string):** Specifies the cookie domain used in the session cookies (CFID/CFTOKEN). - **timeout (string):** Specifies the expires value of the session cookies (CFID/CFTOKEN), in days. Set to -1 for browser session cookies. - **sameSite (string):** Specifies if the cookies should be restricted to a first-party or same-site context. Possible values for sameSite are `lax \| strict \| none` |  |
| enableNULLSupport | boolean | No | Enable Full Null support |  |
| nullSupport | boolean | No | enable or disable full null support |  |
| preciseMath | boolean | No | If set to true Lucee increases memory size for arithmetic operations and numbers. This improves the accuracy of floating point calculations. |  |
| psq | boolean | No | preserve single quote in injected variables into cfquery. |  |
| variableUsage | string | No | how to handle variable usage within cfquery, possible values are - ignore - warn - error |  |
| cachedAfter | timespan | No | set the timespan for the attribute "cachedAfter" from tag "query". |  |
| blockedExtForFileUpload | string | No | A comma separated list of file extensions that will be blocked for File Upload operation |  |
| javaSettings | struct | No | A struct that enables loading of application-specific Java libraries from a custom path. The following keys are supported: - **loadPaths:** An array of paths, or comma delimitered list of jar files, or directories containing jar files. This or Bundles is required. - **bundles:** Any array of paths, or comma delimitered list of OSGI jar files, or directories containing OSGI jar files. This or LoadPaths is required. - **loadCFMLClassPath (default:false):** Indicates whether underlying Lucee classes should be loaded. - **reloadOnChange (default:false):** Indicates if loaded Java libraries should be watched and reloaded if they change, without needing to restart the server. - **watchInterval (default:60):** The interval, in seconds, for checking the loaded Java libraries for changes. Only applicable if *reloadOnChange* is true. - **watchExtensions (default:"class,jar"):** A list of the file extensions to monitor for changes. |  |
| xmlFeatures | struct | No | Allows to set XML Features to prevent XXE attacks - disallowDoctypeDecl (true / false) - externalGeneralEntities (true/false) - secure (true/false) |  |
| regex | any | No | A struct containing the configuration for regular expressions ATM only the key "engine" is supported Engines: - **perl:** Use perl as regex engine - **java:** Use java as regex engine i.e. `{engine: "perl"}` ``` this.useJavaAsRegexEngine = true; ``` also works |  |
| sameFormFieldsAsArray | boolean | No | Default False When true, form fields with the same name will be combined into an array. This only works via Application.cfc |  |
| sameURLFieldsAsArray | boolean | No | Default False When true, url fields/parameters with the same name will be combined into an array. This only works via Application.cfc |  |
| showdoc | boolean | No | Show documentation output at the end of the webpage or not. *Alias: doc* |  |
| showmetric | boolean | No | Show metric output at the end of the webpage or not. *Alias: metric* |  |
| showdebug | boolean | No | Show debug output at the end of the webpage or not. *Alias: debug* |  |
| debuggingDatabase | boolean | No | Log debugging information from the queries in the request |  |
| debuggingException | boolean | No | Log debugging information from the exceptions in the request |  |
| debuggingDump | boolean | No | Log debugging information from the dump tag in the request |  |
| debuggingTracing | boolean | No | Log debugging information from the trace tag in the request |  |
| debuggingTimer | boolean | No | Log debugging information from the timer tag in the request |  |
| debuggingImplicitAccess | boolean | No | Log debugging information about unscoped variables accessed in the request |  |
| debuggingQueryUsage | boolean | No | Log debugging information about which columns in queries are used the request |  |
| debuggingThread | boolean | No | Log debugging information about threads used in the request |  |
| debuggingTemplate | boolean | No | Log debugging information about templates used in the request |  |

# Examples

*There are currently no examples for this tag.*








# Categories

[Application](../../categories/application.md), [Core CFML Language](../../categories/core.md), [Scopes](../../categories/scopes.md), [Session](../../categories/session.md)

# See Also

[Application.cfc guide](../../recipes/application-cfc.md), [Breaking Changes between Lucee 6.2 and 7.0](../../recipes/breaking-changes-7.md), [Adding Caches via Application.cfc](../../recipes/caches-defined-in-application-cfc.md), [Configuration - CFConfig.json](../../recipes/configuration.md), [ApplicationPathCacheClear()](../functions/applicationpathcacheclear.md), [ApplicationStop()](../functions/applicationstop.md), [GetApplicationMetadata()](../functions/getapplicationmetadata.md), [GetApplicationSettings()](../functions/getapplicationsettings.md), [SessionCommit()](../functions/sessioncommit.md), [SessionExists()](../functions/sessionexists.md), [SessionInvalidate()](../functions/sessioninvalidate.md), [SessionRotate()](../functions/sessionrotate.md), [JavaSettings in Application.cfc, Components and CFConfig.json](../../recipes/java-settings.md), [Mail Listeners](../../recipes/mail-listener.md), [Component Mappings](../../recipes/component-mappings.md), [Custom Tag Mappings](../../recipes/custom-tag-mappings.md), [Define a mapping](../../recipes/mappings-how-to-define-a-reg-mapping.md), [Request Timeout](../../recipes/request-timeout.md), [REST Services with Lucee](../../recipes/rest-services.md), [Setting System Properties and Environment Variables](../../recipes/setting-system-properties-and-env-vars.md), [Session Handling in Lucee](../../recipes/session-handling.md), [Update current Application Context](../../recipes/application-context-update.md)