# <cfajaxproxy>

Creates a JavaScript proxy for a ColdFusion component, for use in an AJAX client.

Alternatively, creates a proxy for a single CFC method, JavaScript function, or URL that is bound to one or more control attribute values.
(Requires AJAX extension)

This tag **may** have a body.
This tag has no [<cfscript>](script.md) support or it uses a different syntax.

```
<cfajaxproxy
    cfc=string
    jsClassName=string
    bind=string
    onError=string
    onSuccess=string
    extends=boolean
    methods=string
><!--- body ---></cfajaxproxy>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| cfc | string | No | the CFC for which to create a proxy. You must specify a dot-delimited path to the CFC. The path can be absolute or relative to location of the CFML page. For example, if the myCFC CFC is in the cfcs subdirectory of the Luceex page, specify cfcs.myCFC. On UNIX based systems, the tag searches first for a file whose name or path corresponds to the specified name or path, but is in all lower case. If it does not find it, Luceex then searches for a file name or path that corresponds to the attribute value exactly, with identical character casing. |  |
| jsClassName | string | No | The name to use for the JavaScript proxy class. |  |
| bind | string | No | **(not supported)** A bind expression that specifies a CFC method, JavaScript function, or URL to call. Cannot be used with the cfc attribute. |  |
| onError | string | No | The name of a JavaScript function to invoke when a bind, specified by the bind attribute fails. The function must take two arguments: an error code and an error message. |  |
| onSuccess | string | No | The name of a JavaScript function to invoke when a bind, specified by the bind attribute succeeds. The function must take one argument, the bind function return value. If the bind function is a CFC function, the return value is automatically converted to a JavaScript variable before being passed to the onSuccess function. |  |
| extends | boolean | No | If true force ajaxproxy to look for remote methods in the cfc extensions chain. Any remote method found will be added to the proxy object. This attribute cannot be used with a bind attribute. |  |
| methods | string | No | Comma delimited list of methods name. If exists only the method ( if remote ) specified will be exposed in the proxy object. |  |

# Examples

*There are currently no examples for this tag.*








# Categories

[Ajax features](../../categories/ajax.md)