# <cfabort>

Stops processing of a page at the tag location.

CFML returns everything that was processed before the cfabort tag.

The cfabort tag is often used with conditional logic to stop processing a page when a condition occurs.

Requests that are terminated with cfabort call the Application.cfc onAbort() method instead of the onRequestEnd().

This tag **cannot** have a body.
This tag is also supported within [<cfscript>](script.md)

```
<cfabort
    showError=string
    type=string
>
```

# Attributes

| Attribute | Type | Required | Description | Default |
|-----------|------|----------|-------------|---------|
| showError | string | No | The error to display when cfabort executes. The error message displays in the standard CFML error page. |  |
| type | string | No | Define the abort type. Allowed Values: * **request** (default): abort the entire request * **page**: abort the current page execution |  |


# Usage Notes

Since 5.3, by default output from [functions](function.md) are no longer buffered when `output=false` is set, as a result, an abort inside a function will no longer work.

You can re-enable this application wide using `this.bufferOutput=true` in your [Application.cfc](application.md), or server wide via the Lucee Administrator, via the Output settings page.

# Examples

```cfml
<cfset v = 3>
<cfloop from="1" to="4" index="c">
    <cfif c is 2>
        aborted
        <cfabort>
    <cfelse>
        <cfset v = v + 1>
    </cfif>
    <cfoutput>c: #c#, v: #v#<br></cfoutput>
</cfloop>
<hr>
<cfoutput>c: #c#, v: #v#</cfoutput>
<br>
not aborted
```








# Categories

[Core CFML Language](../../categories/core.md)

# See Also

[<cfexit>](exit.md)