# Tags

Tags are at the core of Lucee Server's templating language.

CFML Tags can also be called via [<cfscript>](tags/script.md). Usually you don't even need the CF prefix, but you need it in some cases when there is an existing function with the same name. 

You can also omit () when using the [Tag Syntax](../recipes/tag-syntax.md), but the function style is recommended.

```cfml
cflog(text="I called a tag from script");  // use cflog, because there is already a maths [[function-log]] function


cfhttp(url="https://docs.lucee.org");
http url="https://docs.lucee.org";


cflocation(url="https://dev.lucee.org");
location url="https://dev.lucee.org";
```

You can also assign default values for any tag's attributes using *this.tag.tagname.attribute* in Application.cfc.

```cfml
this.tag.cfhttp.username = "system";
this.tag.log.file = "my-custom-log.log";
this.tag.cflocation.addtoken = false;
```

Tags can be called with a struct containing the attributes using *attributeCollection*, Functions use *argumentCollection*

```cfml
attrs = { url="https://dev.lucee.org", addToken="false" };
location attributeCollection=attrs;
cflocation(attributeCollection=attrs);
```

To switch into tag mode, from inside [<cfscript>](tags/script.md) use [Tag Islands](../recipes/tag-islands.md)

- [<cf_socialplugin>](tags/_socialplugin.md) - 
- [<cfabort>](tags/abort.md) - **Stops processing of a page at the tag location.** CFML returns everything that was processed before the cfabort tag. The cfabort tag is often used with conditional logic to stop processing a page when a condition occurs.
- [<cfajaximport>](tags/ajaximport.md) - Controls the JavaScript files that are imported for use on pages that use Luceex AJAX tags and features.
- [<cfajaxproxy>](tags/ajaxproxy.md) - Creates a JavaScript proxy for a component, for use in an AJAX client. Alternatively, creates a proxy for a single CFC method, JavaScript function, or URL that is bound to one or more control attribute values.
- [Application.cfc / <cfapplication>](tags/application.md) - Defines a CFML Application and configures the properties / behavior of that Application
- [<cfargument>](tags/argument.md) - Allows subtag data to be saved with the base tag. Applies only to custom tags.
- [<cfassociate>](tags/associate.md) - Allows subtag data to be saved with the base tag. Applies only to custom tags.
- [<cfauthenticate>](tags/authenticate.md) - Authenticates a user, setting a security context for the application.
For more information, see the descriptions of IsAuthenticated and AuthenticatedContext.
- [<cfbreak>](tags/break.md) - Used to break out of a cfloop,cfwhile or cfforeach.
- [<cfcache>](tags/cache.md) - Speeds up page rendering when dynamic content 
- [<cfcalendar>](tags/calendar.md) - 
- [<cfcase>](tags/case.md) - Handle one case of a cfswitch
- [<cfcatch>](tags/catch.md) - Used only inside a cftry, the cfcatch tag catches and process exceptions.
- [<cfchart>](tags/chart.md) - Generates and displays a chart.
- [<cfchartdata>](tags/chartdata.md) - Used with the cfchart and cfchartseries tags. This tag defines chart data points. Its data is submitted to the cfchartseries tag.
- [<cfchartseries>](tags/chartseries.md) - Used with the cfchart and cfchartseries tags. This tag defines chart data points. Its data is submitted to the cfchartseries tag.
- [<cfclient>](tags/client.md) - 
- [<cfclientsetting>](tags/clientsettings.md) - 
- [<cfcol>](tags/col.md) - Defines table column header, width, alignment, and text. Used only inside a cftable.
- [<cfcollection>](tags/collection.md) - Allows you to create and administer search collections for indexing and searching content. 
This tag enables full-text search capabilities, including hybrid vector search when used with embedding services. 
Collections can be queried using different search modes: keyword-based (traditional), vector-based (semantic), or hybrid (combining both approaches). 
Use this tag to manage the lifecycle of search collections that can be populated with cfindex and queried with cfsearch.
- [<cfcomponent>](tags/component.md) - Creates and defines a component object
- [<cfcontent>](tags/content.md) - Defines the MIME type returned by the current page. Optionally, lets you specify the name of a file
to be returned with the page.
- [<cfcontinue>](tags/continue.md) - Used within a cfloop tag. Returns processing to the top of a loop.
- [<cfcookie>](tags/cookie.md) - Defines cookie variables, including expiration and security options.
- [<cfdbinfo>](tags/dbinfo.md) - Lets you retrieve information about a data source, including details about the database, tables, queries, procedures, foreign keys, indexes, and version information about the database, driver, and JDBC. This tag supports only JDBC drivers, and does not support ODBC-based drivers, including the Microsoft Access driver.
- [<cfdefaultcase>](tags/defaultcase.md) - Defines a default action inside a cfswitch statement, when none of the cfcase condition statements are true.
- [<cfdirectory>](tags/directory.md) - Handles interactions with directories.
- [<cfdistributedlock>](tags/distributedlock.md) - Redis based lock that can be used across servers
- [<cfdiv>](tags/div.md) - Creates an HTML tag with specified contents and lets you to use bind expressions to dynamically control the tag contents.
- [<cfdocument>](tags/document.md) - Creates a PDF document from a text block containing CFML and HTML.
- [<cfdocumentitem>](tags/documentitem.md) - Specifies action items for a PDF document created by the cfdocument tag.
- [<cfdocumentsection>](tags/documentsection.md) - Divides a PDF document into sections.
- [<cfdump>](tags/dump.md) - Outputs the elements, variables and values of most kinds of CFML objects. Useful for debugging. You can display the contents of simple and complex variables, objects, components, user-defined functions, and other elements.
- [<cfelse>](tags/else.md) - Used with cfelse and cfelseif, cfif lets you create simple and compound conditional statements
in CFML. The value in the cfif tag can be any expression.
- [<cfelseif>](tags/elseif.md) - Used with cfelse and cfelseif,
cfif lets you create simple and compound conditional statements
in CFML. The value in the cfif tag can be any expression.
- [<cferror>](tags/error.md) - Enables the display of customized HTML pages when errors occur. This lets you maintain a
consistent look and feel within your application, even when errors occur.
- [<cfexchangecalendar>](tags/exchangecalendar.md) - 
- [<cfexchangeconnect>](tags/exchangeconnection.md) - 
- [<cfexchangecontact>](tags/exchangecontact.md) - 
- [<cfexchangeconversation>](tags/exchangeconversation.md) - 
- [<cfexchangefilter>](tags/exchangefilter.md) - 
- [<cfexchangefolder>](tags/exchangefolder.md) - 
- [<cfexchangemail>](tags/exchangemail.md) - 
- [<cfexchangetask>](tags/exchangetask.md) - 
- [<cfexecute>](tags/execute.md) - Enables developers to execute a process on a server computer.
- [<cfexit>](tags/exit.md) - Used to: Abort the processing of the currently executing CFML custom tag, exit the template
within the currently executing CFML custom tag and re-execute a section of code within the currently
executing CFML custom tag
- [<cffeed>](tags/feed.md) - Reads or creates an RSS or Atom syndication feed.
This tag can read various RSS and Atom 0.3 versions. It can create RSS 2.0 or Atom 1.0 feeds.
- [<cffile>](tags/file.md) - Handles all interactions with files
- [<cffileupload>](tags/fileupload.md) - This tag is not supported by Lucee.
- [<cffinally>](tags/finally.md) - Used inside a cftry tag.
Code in the cffinally block is processed after the main cftry code and, if an exception occurs, the cfcatch code.
The cffinally block code always executes, whether or not there is an exception.
- [<cfflush>](tags/flush.md) - Flushes currently available data to the client.
- [<cfform>](tags/form.md) - Builds a form with CFML custom control tags that provide more functionality than standard
HTML form input elements (XML and Flash type not supported).
- [<cfformgroup>](tags/formgroup.md) - 
- [<cfformitem>](tags/formitem.md) - 
- [<cfforward>](tags/forward.md) - Leads the request to a different page.
This tag acts like the tag cflocation except that the relocation is done directly on the server.
- [<cfftp>](tags/ftp.md) - Lets users implement File Transfer Protocol (FTP) operations.
- [<cffunction>](tags/function.md) - Defines a function within a CFML component that can accept arguments and return a value.
- [<cfgrid>](tags/grid.md) - 
- [<cfgridcolumn>](tags/gridcolumn.md) - 
- [<cfgridrow>](tags/gridrow.md) - 
- [<cfgridupdate>](tags/gridupdate.md) - 
- [<cfheader>](tags/header.md) - Generates custom HTTP response headers to return to the client.
- [<cfhtmlbody>](tags/htmlbody.md) - Writes the text specified in the text attribute to the 'body' section of a generated HTML page.
The cfhtmlbody tag can be useful for embedding JavaScript code, or placing other HTML tags that should go at the bottom
of the page just before the closing body tag.
- [<cfhtmlhead>](tags/htmlhead.md) - Writes the text specified in the text attribute to the 'head' section of a generated HTML page.
The cfhtmlhead tag can be useful for embedding JavaScript code, or placing other HTML tags such, as
META, LINK, TITLE, or BASE in an HTML page header.
- [<cfhtmltopdf>](tags/htmltopdf.md) - 
- [<cfhtmltopdfitem>](tags/htmltopdfitem.md) - 
- [<cfhttp>](tags/http.md) - Lets you execute HTTP POST and GET operations on files.
- [<cfhttpparam>](tags/httpparam.md) - Required for cfhttp POST operations, cfhttpparam is used to specify the parameters necessary to
build a cfhttp POST.
- [<cfif>](tags/if.md) - Used with cfelse and cfelseif, cfif lets you create simple and compound conditional statements
in CFML. The value in the cfif tag can be any expression.
- [<cfimage>](tags/image.md) - Lets you resize and add labels to GIF and JPEG format images.
- [<cfimap>](tags/imap.md) - Retrieves and deletes messages from an IMAP email server.
- [<cfimapfilter>](tags/imapfilter.md) - 
- [<cfimport>](tags/import.md) - The tag `import` has multiple purposes:
1. Import components with the attribute `path`
2. Import Java classes (Lucee 6.2+) with the attribute `path` or its alias `java` 
3. Import CFML/JSP custom tags with the attributes `prefix` and `taglib`
In script syntax, you can use:
- `cfimport(path="org.lucee.example.MyCFC");` 
- `import org.lucee.example.MyCFC;` 
- `import "org.lucee.example.MyCFC";`
For importing multiple components, use the wildcard syntax:
- `import "org.lucee.example.*";`
For Java classes (Lucee 6.2+), the classpath is shared between components and Java classes. By default, Lucee first looks for components and then for Java classes if not found. Optionally, you can explicitly specify the type:
- `import java:java.util.HashMap;`
- `import cfml:org.lucee.cfml.Query;`
Note: Imports only affect the current template, not the entire request.
Reference: See addional documentation for import at https://github.com/lucee/lucee-docs/blob/master/docs/recipes/import.md
- [<cfinclude>](tags/include.md) - Lets you embed references to pages in CFML. You can embed cfinclude tags recursively.
For an additional method of encapsulating CFML
- [<cfindex>](tags/index.md) - Populates a full text search collections with indexed data.
- [<cfinput>](tags/input.md) - Used inside cfform to place radio buttons, checkboxes, or text boxes. Provides input
validation for the specified control type.
- [<cfinsert>](tags/insert.md) - Inserts records in data sources.
- [<cfinterface>](tags/interface.md) - Defines an interface that consists of a set of signatures for functions.
- [<cfinvoke>](tags/invoke.md) - Invokes component methods from within a page or component.
You use this tag to reference a WSDL file and consume a web service from within a block of CFML code.
- [<cfinvokeargument>](tags/invokeargument.md) - Argument for the Invoke Tag
- [<cflayout>](tags/layout.md) - 
- [<cflayoutarea>](tags/layoutarea.md) - 
- [<cfldap>](tags/ldap.md) - Provides an interface to LDAP Lightweight Directory Access Protocol
directory servers like the Netscape Directory Server.
- [<cflocation>](tags/location.md) - Redirect the current request to another URL.
- [<cflock>](tags/lock.md) - Provides two types of locks to ensure the integrity of shared data: Exclusive lock and Read-only lock.
- [<cflog>](tags/log.md) - Writes a message to a log file.
- [<cflogin>](tags/login.md) - A container for user login and authentication code.
- [<cfloginuser>](tags/loginuser.md) - Identifies an authenticated user to ColdFusion. Specifies the user ID and roles. Used within a cflogin tag.
- [<cflogout>](tags/logout.md) - Logs the current user out. Removes knowledge of the user ID, password, and roles from the server.
If you do not use this tag, the user is automatically logged out when the session ends.
- [<cfloop>](tags/loop.md) - Looping is a very powerful programming technique that lets you repeat a set of instructions or
display output repeatedly until one or more conditions are met. cfloop supports five types of loops.
- [<cfmail>](tags/mail.md) - Sends e-mail messages by an SMTP server.
- [<cfmailparam>](tags/mailparam.md) - Can either attach a file or add a header to a message. It is nested within a cfmail tag. You can
use more than one cfmailparam tag within a cfmail tag.
- [<cfmailpart>](tags/mailpart.md) - Specifies one part of a multipart e-mail message. Can only be used in the cfmail tag. You can use more than one cfmailpart tag within a cfmail tag
- [<cfmap>](tags/map.md) - 
- [<cfmapitem>](tags/mapitem.md) - 
- [<cfmenu>](tags/menu.md) - 
- [<cfmenuitem>](tags/menuitem.md) - 
- [<cfmessagebox>](tags/messagebox.md) - 
- [<cfmodule>](tags/module.md) - Invokes a custom tag for use in cfml templates. The cfmodule tag can help deal with
custom tag name conflicts. Use the template attribute to name a template that contains the custom
tag definition, including its path..
- [<cfntauthenticate>](tags/ntauthenticate.md) - 
- [<cfoauth>](tags/oauth.md) - 
- [<cfobject>](tags/object.md) - Lets you call methods in COM, CORBA, and JAVA objects.
- [<cfobjectcache>](tags/objectcache.md) - Flushes an object cache or returns the current size.
- [<cfoutput>](tags/output.md) - Displays the results of a database query or other operation. To nest cfoutput tags, see the "Usage" section.
- [<cfpageencoding>](tags/pageencoding.md) - Specifies the character encoding used for the current template file. This tag is processed at compile time and must be placed at the root level of your template. It serves the same purpose as the pageEncoding attribute of cfprocessingdirective but in a dedicated tag format.
- [<cfparam>](tags/param.md) - Tests for a parameter's existence, tests its data type, and provides a default value if one
is not assigned.
- [<cfpdf>](tags/pdf.md) - Manipulates existing PDF documents.
- [<cfpdfparam>](tags/pdfparam.md) - Provides additional information for the cfpdf tag. The cfpdfparam tag applies only to the merge action of the cfpdf tag and is always a child tag of the cfpdf tag.
- [<cfpod>](tags/pod.md) - 
- [<cfpop>](tags/pop.md) - Retrieves and deletes e-mail messages from a POP mail server.
- [<cfpresentation>](tags/presentation.md) - 
- [<cfpresentationslide>](tags/presentationslide.md) - 
- [<cfpresenter>](tags/presenter.md) - 
- [<cfprocessingdirective>](tags/processingdirective.md) - Sets compiler directives that affect the entire template. Unlike most CFML tags, cfprocessingdirective is processed at compile time and must be placed at the root level of your template.
- [<cfprocparam>](tags/procparam.md) - Specifies parameter information, including type, name, value, and length. The cfprocparam tag
is nested within a cfstoredproc tag.
- [<cfprocresult>](tags/procresult.md) - Specifies a result set name that other tags, such as cfoutput and cftable, use to access
the result set. It also lets you optionally identify which of the stored procedure's result sets to
return. The cfprocresult tag is nested within a cfstoredproc tag.
- [<cfprogressbar>](tags/progressbar.md) - 
- [<cfproperty>](tags/property.md) - Defines properties within components that can be used for web services, ORM mapping, and accessor method generation. Properties are exposed as component metadata and follow component inheritance rules.
- [<cfquery>](tags/query.md) - Passes SQL statements to a data source. Not limited to queries.
- [<cfqueryparam>](tags/queryparam.md) - Checks the data type of a query parameter.
- [<cfregistry>](tags/registry.md) - Reads, writes, and deletes keys and values in the system registry. The cfregistry tag is supported
on all platforms, including Linux, Solaris, and HP-UX.
- [<cfreport>](tags/report.md) - 
- [<cfreportparam>](tags/reportparam.md) - 
- [<cfrethrow>](tags/rethrow.md) - Rethrows the currently active exception. Preserves the exception's cfcatch.type and cfcatch.
agContext information.
- [<cfretry>](tags/retry.md) - used to jump from a catch block, back to the beginning of the try block.
- [<cfreturn>](tags/return.md) - Returns result values from a component method. Contains an expression returned as result of the function.
- [<cfsavecontent>](tags/savecontent.md) - Saves the generated content inside the tag body in a variable.
- [<cfschedule>](tags/schedule.md) - Provides a programmatic interface to the scheduling engine. You can run a specified
page at scheduled intervals with the option to write out static HTML pages. This lets you offer users
access to pages that publish data, such as reports, without forcing users to wait while a database transaction
is performed in order to populate the data on the page.
- [<cfscript>](tags/script.md) - Encloses a code segment containing cfscript.
- [<cfsearch>](tags/search.md) - Executes searches against data indexed
- [<cfselect>](tags/select.md) - Used inside cfform, cfselect lets you construct a drop-down list box form control. You can
populate the drop-down list box from a query, or using the option tag. Use option elements to populate
lists. The syntax for the option tag is the same as for its HTML counterpart.
- [<cfservlet>](tags/servlet.md) - This tag has been deprecated and is non-functional.
- [<cfservletparam>](tags/servletparam.md) - This tag has been deprecated and is non-functional.
- [<cfset>](tags/set.md) - Define a CFML variable. If the variable exists, cfset resets it to the specified value.
- [<cfsetting>](tags/setting.md) - Controls various aspects of page processing, such as the output of HTML code in pages. One
benefit of this option is managing whitespace that can occur in output pages served by CFML.
- [<cfsharepoint>](tags/sharepoint.md) - 
- [<cfsilent>](tags/silent.md) - Suppresses all output that is produced by the CFML within the tag's scope.
- [<cfsleep>](tags/sleep.md) - Pauses the execution of the page for a given interval
- [<cfslider>](tags/slider.md) - Used inside cfform, cfslider lets you place a slider control in a CFML form. A slider
control is like a sliding volume control. The slider groove is the area over which the slider moves.
- [<cfspreadsheet>](tags/spreadsheet.md) - 
- [<cfsprydataset>](tags/sprydataset.md) - 
- [<cfstatic>](tags/static.md) - defines a static constructor within components
- [<cfstopwatch>](tags/stopwatch.md) - Stops the time from startTag to endTag
- [<cfstoredproc>](tags/storedproc.md) - Executes stored procedures by an ODBC or native connection to a server database. It specifies database connection
information and identifies the stored procedure.
- [<cfswitch>](tags/switch.md) - Used with cfcase and cfdefaultcase. Evaluates a passed expression and passes control to the
cfcase tag that matches the expression result. You can optionally code a cfdefaultcase tag, which
receives control if there is no matching cfcase tag value.
- [<cftable>](tags/table.md) - Builds a table in a CFML page. Use the cfcol tag to define table column and row
characteristics. The cftable tag renders data either as preformatted text, or, with the HTMLTable
attribute, as an HTML table. Use cftable to create tables if you don't want to write HTML table tag
code, or if your data can be well presented as preformatted text.
- [<cftextarea>](tags/textarea.md) - 
- [<cfthread>](tags/thread.md) - The cfthread tag enables you to create threads, independent streams of code execution, in your application.
- [<cfthrow>](tags/throw.md) - The cfthrow tag raises a developer-specified exception
- [<cftimeout>](tags/timeout.md) - 
- [<cftimer>](tags/timer.md) - Displays execution time for a specified section of CFML code.
- [<cftooltip>](tags/tooltip.md) - 
- [<cftrace>](tags/trace.md) - Displays and logs debugging data about the state of an application at the time the cftrace tag executes.
- [<cftransaction>](tags/transaction.md) - Groups multiple queries into a single unit. The cftransaction
tag provides commit and rollback processing.
- [<cftree>](tags/tree.md) - 
- [<cftreeitem>](tags/treeitem.md) - 
- [<cftry>](tags/try.md) - Used with one or more cfcatch tags, the cftry tag lets you catch and process exceptions in CFML pages.
- [<cfupdate>](tags/update.md) - Updates existing records in data sources.
- [<cfwddx>](tags/wddx.md) - Serializes and de-serializes CFML data structures to the XML-based WDDX format.
- [<cfwebsocket>](tags/websocket.md) - 
- [<cfwhile>](tags/while.md) - Simplification of the tag cfloop-condition, analog to the cfscript "while" loop.
- [<cfwindow>](tags/window.md) - Creates a pop-up window in the browser. Does not create a separate browser pop-up instance.
- [<cfxml>](tags/xml.md) - Creates a CFML XML document object that contains the markup in the tag body. This tag can include XML and CFML tags.
Lucee processes the CFML code in the tag body, then assigns the resulting text to an XML document object variable.
- [<cfzip>](tags/zip.md) - Manipulates ZIP and Java Archive (JAR) files.
- [<cfzipparam>](tags/zipparam.md) - The cfzipparam tag is always a child tag of the cfzip tag. see tag zip for more details.

# See Also

[Tag Islands](../recipes/tag-islands.md), [Tag Syntax](../recipes/tag-syntax.md)