# xml.search()

Uses an XPath language expression to search an XML document object.

```
xml.search( xpath=string )
```

**Returns:** object

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| xpath | string | Yes | XPath expression *Alias: path, xPathString* |  |

# Examples

```cfml
<cfxml variable="xmlobject">
	<office>
		<employee>
			<emp_role>lucee_dev
				<emp_name>mark</emp_name>
				<emp_id>102</emp_id>
				<emp_jobrole>software</emp_jobrole>
			</emp_role>
		</employee>
	</office>
</cfxml>
<cfset res = xmlobject.search("/office/employee/")>
<cfdump var="#res#" />
```

# Categories

[XML](../../../categories/xml.md)

# See Also

[XmlSearch()](../../functions/xmlsearch.md), [Xml](../xml.md)