# xml.childPos()

Gets the position of a child element within an XML document
object.
The position, in an XmlChildren array, of the Nth child that
has the specified name.

```
xml.childPos( childName=string, index=number )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| childName | string | Yes | XML child element for which to search |  |
| index | number | Yes | Index of XMLchild element for which to search. |  |

# Examples

```cfml
 <cfxml variable="xmlobject">
	<office>
		<employee>
			<emp_role>lucee_dev
				<emp_name>mark</emp_name>
				<emp_id>102</emp_id>
				<emp_jobrole>software</emp_jobrole>
			</emp_role>
		</employee>
	</office>
</cfxml>
<cfset res = xmlobject.xmlroot.ChildPos("employee",1)>
<cfdump var="#res#" />
```

# Categories

[XML](../../../categories/xml.md)

# See Also

[XmlChildPos()](../../functions/xmlchildpos.md), [Xml](../xml.md)