# struct.update()

Updates a key with a value.

```
struct.update( key=string, value=any )
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| key | string | Yes | Key, the value of which to update |  |
| value | any | Yes | New value |  |

# Examples

```cfml
	  world = {
        save:"water",
        plant:"trees",
        clean:"waste"
    };
    writedump(world);
    updateStruct = structupdate(world,"clean","room");
    writeDump(updatestruct);
```

# Categories

[Structures](../../../categories/struct.md)

# See Also

[StructUpdate()](../../functions/structupdate.md), [Struct](../struct.md)