# struct.toSorted()

Returns a struct sorted by the top level keys in a structure.
Sorts using alphabetic or numeric sorting.

**Introduced:** 6.2.1.6

```
struct.toSorted( sortTypeOrSortFunc=any, sortOrder=string, localeSensitive=boolean )
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| sortTypeOrSortFunc | any | No | The following sort types are available: - numeric: sorts numbers - text: sorts text alphabetically, taking case into account (case sensitive, default) - textNoCase: sorts text alphabetically, without regard to case (case insensitive) or a function to be used as a comparator (introduced 6.2.1) `function(key1, key2)` *Alias: sortType* |  |
| sortOrder | string | No | Sort direction: - asc (default): ascending (a to z) sort order - desc: descending (z to a) sort order |  |
| localeSensitive | boolean | No | Use locale aware sort |  |

# Examples

### Member Function

```cfml
    myNestedStruct = {
        "apple" = { "price" = 3, "quantity" = 10 },
        "banana" = { "price" = 1, "quantity" = 5 },
        "cherry" = { "price" = 2, "quantity" = 8 },
        "date" = { "price" = 4, "quantity" = 12 }
    };
    writeDump(var=myNestedStruct,label="Before sorting");
    writeDump(var=myNestedStruct.toSorted("textNoCase","desc","true"),label="After sorting");
```

### Example using callback

```cfml
   myNumb.4="5";
   myNumb.3="2";
   myNumb.2="3";
   myNumb.1="1";
   cb = function( value1, value2, key1, key2 ){
      if (arguments.value1 < arguments.value2 ) // i.e. desc
        return 1;
      else
        return -1;
    };
    writeDump(var=myNumb, label="Before sorting");
    writeDump(var=myNumb.toSorted(cb),label="After sorting");
```

# Categories

[Structures](../../../categories/struct.md), [Sorting](../../../categories/sort.md)

# See Also

[StructToSorted()](../../functions/structtosorted.md), [Struct](../struct.md)