# struct.sort()

Returns a sorted array of the top level keys in a structure.
Sorts using alphabetic or numeric sorting, and can sort based
on the values of any structure element.

```
struct.sort( sortTypeOrSortFunc=any, sortOrder=string, pathToSubElement=string )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| sortTypeOrSortFunc | any | No | Define one of the following: - numeric: sorts numbers - text: sorts text alphabetically, taking case into account (case sensitive) - textNoCase: sorts text alphabetically, without regard to case (case insensitive) or a function to be used as a comparator (introduced 6.2.1) `function(value1, value2, key1, key2)` *Alias: sortType* |  |
| sortOrder | string | No | Sort direction: - asc (default): ascending (a to z) - desc: descending (z to a) |  |
| pathToSubElement | string | No | String or a variable that contains one *Alias: path* |  |

# Examples

### Member Function

```cfml
        animals = {
                cat:"rat",
                lion:"deer",
                bear:"fish"
        };
        writedump(var=animals,label="Before sorting");
        sort = animals.sort("text","asc");
        writeDump(var=sort,label="After sorting");
```

### Example using callback (Introduced in 6.2.1.29)

```cfml
    myStruct={a="London",b="Paris",c="Berlin",d="New York",e="Dublin"};
    function callback(e1, e2){
        return compare(arguments.e1, arguments.e2);
    }
    writeDump(var=myStruct,label="Before sorting");
    writeDump(var=myStruct.Sort(callback),label="After sorting");
```

# Categories

[Structures](../../../categories/struct.md), [Sorting](../../../categories/sort.md)

# See Also

[StructSort()](../../functions/structsort.md), [Struct](../struct.md)