# struct.some()

This function calls a closure/function on every element in a struct until one returns true.

If one of the closure calls it will return returns true, otherwise false

```
struct.some( closure=function, parallel=boolean, maxThreads=number )
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | function/closure that implements the following constructor `function(key, value, st){}` and returns a boolean value *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
st = {
	1 : { active: true},
	2 : { active: false},
	3 : { active: false}
};

result = st.some(function(key,value){
	dump(var=value, label=key);
	return value.active;
});
dump (result);
```

# Categories

[Iterator](../../../categories/iterator.md), [Structures](../../../categories/struct.md)

# See Also

[StructSome()](../../functions/structsome.md), [Struct](../struct.md)