# struct.reduce()

Iterates over every entry of the given struct and calls the closure with every key/value.

This function will reduce the struct to a single value and will return this value.

```
struct.reduce( closure=function, initialValue=object )
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | function/closure that implements the following constructor `function(result, key, value, st) { return result; }` *Alias: function, callback, udf* |  |
| initialValue | object | No | initial value passed as part of the first closure call *Alias: initial, initalValue* |  |

# Examples

### Member Function

```cfml
animals = {
	cow: {noise: "moo",  size: "large"},
	pig: {noise: "oink", size: "medium"},
	cat: { noise: "meow", size: "small"}
};

dump(label: "All animals", var: animals);

animalInfo = animals.reduce(function(result, key, value) {
	return arguments.result & "<li>" & arguments.key & "<ul><li>Noise: " & arguments.value.noise & "</li><li>Size: " & arguments.value.size & "</li></ul></li>";
}, "<ul>") & "</ul>";

// Show result
echo(animalInfo);
```

# Categories

[Iterator](../../../categories/iterator.md), [Structures](../../../categories/struct.md), [Threads](../../../categories/thread.md)

# See Also

[StructReduce()](../../functions/structreduce.md), [Struct](../struct.md)