# struct.map()

Calls the given closure with every element in the given struct.

The function returns a struct that contains all values returned by the closure.

```
struct.map( closure=function, parallel=boolean, maxThreads=number )
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| closure | function | Yes | filter can be a function/closure that implements the following constructor [function(string key, any value[, struct struct]):any]. *Alias: function, callback, udf* |  |
| parallel | boolean | No | execute closures parallel |  |
| maxThreads | number | No | maximum number of threads executed, ignored when argument "parallel" is set to false *Alias: maxThreadCount* |  |

# Examples

```cfml
	original = {
	    "one": {
	        1: "map"
	    },
	    "two": {
	        2: "struct"
	    },
	    "three": {
	        3: "mapstruct"
	    },
	    "four": {
	        4: "structmap"
	    }
	};
	function mapOriginal(k,v) {
	    return v[ListFirst(v.keyList())];
	}
	fixed = original.Map(mapOriginal);
	writeDump([original, fixed]);
```

# Categories

[Iterator](../../../categories/iterator.md), [Structures](../../../categories/struct.md), [Threads](../../../categories/thread.md)

# See Also

[StructMap()](../../functions/structmap.md), [Struct](../struct.md)