# struct.keyTranslate()

Converts any struct keys with dot notation into nested structures

```
struct.keyTranslate( deepTranslation=boolean, leaveOriginalKey=boolean )
```

**Returns:** number

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| deepTranslation | boolean | No | also translate keys of child structures |  |
| leaveOriginalKey | boolean | No | leave original key in struct |  |

# Examples

```cfml
	animals = {
		cow: {
		    noise: "moo",
		    size: "large"
		},
		"bird.noise": "chirp",
		"bird.size": "small"
	};
	// Show all animals
	Dump(
		label: "All animals",
		var: animals
	);
	// Call function
	animals.keyTranslate();
	// Show all animals after keyTranslate
	Dump(
		label: "All animals after keyTranslate",
		var: animals
	);
```

# Categories

[Structures](../../../categories/struct.md)

# See Also

[StructKeyTranslate()](../../functions/structkeytranslate.md), [Struct](../struct.md)