# struct.keyExists()

Determines whether a specific key is present in a structure.

```
struct.keyExists( key=string )
```

**Returns:** boolean

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| key | string | Yes | Key to test |  |

# Examples

```cfml
animals = {
	cow: "moo",
	pig: "oink",
	cat: "meow",
	bird: "chirp"
};
// Check to see if key exists in struct
if (
	animals.keyExists("snail")
) {
	echo("There is a snail in 'animals'");
} else {
	echo("No snail exists in 'animals'");
}
```

# Categories

[Structures](../../../categories/struct.md)

# See Also

[StructKeyExists()](../../functions/structkeyexists.md), [Struct](../struct.md)