# struct.insert()

Inserts a key-value pair into a structure.

```
struct.insert( key=string, value=any, allowOverwrite=boolean )
```

**Returns:** struct

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| key | string | Yes | Key that contains the inserted value. |  |
| value | any | Yes | Value to add. |  |
| allowOverwrite | boolean | No | Whether to allow overwriting a key. Default: False. *Alias: overwrite* |  |

# Examples

```cfml
animals = {
	cow: "moo",
	pig: "oink"
};
// Show current animals
Dump(
	label: "Current animals",
	var: animals
);
// Insert cat into animals
animals.insert("cat", "meow");
// Show animals, now includes cat
Dump(
	label: "Animals with cat added",
	var: animals
);
```

# Categories

[Structures](../../../categories/struct.md), [Iterator](../../../categories/iterator.md)

# See Also

[StructInsert()](../../functions/structinsert.md), [Struct](../struct.md)