# struct.findValue()

Searches recursively through a substructure of nested arrays,
structures, and other elements for structures with values that
match the search key in the value parameter.

```
struct.findValue( Key=string, Scope=string )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| Key | string | Yes | Value for which to search |  |
| Scope | string | No | - one (default): function returns one matching key - all: function returns all matching keys |  |

# Examples

```cfml
animals = {
	cow: {
		noise: "moo",
		size: "large"
	},
	pig: {
		noise: "oink",
		size: "medium"
	},
	cat: {
		noise: "meow",
		size: "small"
	}
};
// Show all animals
Dump(
	label: "All animals",
	var: animals
);
// Find animal containing value of 'medium'
findMediumAnimal = animals.findValue("medium");
// Show results in findMediumAnimal
Dump(
	label: "Results of animals.findValue(""medium"")",
	var: findMediumAnimal
);
```

# Categories

[Structures](../../../categories/struct.md)

# See Also

[StructFindValue()](../../functions/structfindvalue.md), [Struct](../struct.md)