# struct.findKey()

Searches recursively through a substructure of nested arrays,
structures, and other elements, for structures whose values
match the search key in the value parameter.

```
struct.findKey( Key=string, Scope=string )
```

**Returns:** array

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| Key | string | Yes | Key for which to search. |  |
| Scope | string | No | - one (default): returns one matching key. - all: returns all matching keys |  |

# Examples

```cfml
animals = {
	cow: {
		noise: "moo",
		size: "large"
	},
	pig: {
		noise: "oink"
	},
	cat: {
		noise: "meow",
		size: "small"
	}
};
// Show all animals
Dump(
	label: "All animals",
	var: animals
);
// Find "all" animal(s) containing key of 'size'
findAnimalsWithSize = animals.findKey("size", "all");
// Show results in findAnimalsWithSize
Dump(
	label: "Results of animals.findKey(""size"", ""all"")",
	var: findAnimalsWithSize
);
```

# Categories

[Structures](../../../categories/struct.md)

# See Also

[StructFindKey()](../../functions/structfindkey.md), [Struct](../struct.md)