# struct.find()

Determines the value associated with a key in a structure.

```
struct.find( key=string, defaultValue=any )
```

**Returns:** any

# Arguments

| Argument | Type | Required | Description | Default |
|----------|------|----------|-------------|---------|
| key | string | Yes | Key whose value to return |  |
| defaultValue | any | No | Default value which will be returned if the key does not exist or if null was found |  |

# Examples

```cfml
	animals = {
		cow: "moo",
		pig: "oink",
		cat: "meow"
	};
	// Show all animals
	Dump(
		label: "All animals",
		var: animals
	);
	// Find cat in animals
	findCat = animals.find("cat");
	// Show results of findCat
	Dump(
		label: "Results of animals.find(""cat"")",
		var: findCat
	);
	// If the key does not exist, we can set a default value. In this case a blank string.
	findSnail = animals.find("snail", " ");
	// Show results of findSnail
	Dump(
		label: "Results of animals.find(""snail"", """")",
		var: findSnail
	);
```

# Categories

[Structures](../../../categories/struct.md)

# See Also

[StructFind()](../../functions/structfind.md), [Struct](../struct.md)